/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing.graph;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.JComponent;

public class OverlayDraw
extends JComponent
implements MouseListener,
MouseMotionListener {
    public static final int MARK_RECT = 0;
    public static final int MARK_OVAL = 1;
    public static final int MARK_NO_ACTION = -1;
    public static final int MARK_CREATED = 0;
    public static final int MARK_CHANGED = 1;
    public static final int MARK_MOVED = 2;
    protected int createType = 1;
    protected Vector markList = new Vector();
    protected Vector markListeners = new Vector();
    protected Color markColor = Color.black;
    protected int markAction;
    protected Mark selectedMark;
    protected Rectangle selectedHandle;
    protected Point pressed;
    protected Component component;
    protected boolean creating = false;
    protected int handleWidth = 8;
    protected int handleHeight = 8;

    public OverlayDraw(Component component) {
        this.component = component;
        this.setEnabled(true);
    }

    public boolean isCreating() {
        return this.creating;
    }

    public void setCreating(boolean value) {
        this.creating = value;
    }

    @Override
    public void setEnabled(boolean enabled) {
        Container container = this.component.getParent();
        if (container instanceof Container) {
            if (enabled) {
                container.add((Component)this, 0);
                this.setBounds(this.component.getBounds());
                this.addMouseListener(this);
                this.addMouseMotionListener(this);
            } else {
                this.removeMouseListener(this);
                this.removeMouseMotionListener(this);
                this.component.setBounds(this.getBounds());
                container.remove(this);
            }
        }
    }

    @Override
    public boolean isEnabled() {
        Container parent = this.getParent();
        if (parent == null) {
            return false;
        }
        Component[] components = parent.getComponents();
        int i = 0;
        while (i < components.length) {
            if (components[i] == this) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Color getColor() {
        return this.markColor;
    }

    public void setColor(Color color) {
        this.markColor = color;
    }

    public Mark findMark(Point point) {
        int i = 0;
        while (i < this.markList.size()) {
            Mark mark = (Mark)this.markList.elementAt(i);
            if (mark.contains(point)) {
                return mark;
            }
            ++i;
        }
        return null;
    }

    public void setHandleSize(int w, int h) {
        this.handleWidth = w;
        this.handleHeight = h;
    }

    @Override
    protected void paintComponent(Graphics g) {
        int i = 0;
        while (i < this.markList.size()) {
            Mark mark = (Mark)this.markList.elementAt(i);
            mark.draw(g);
            ++i;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.pressed = e.getPoint();
        if (this.creating) {
            Mark mark = new Mark(this.createType, this.pressed);
            this.markList.addElement(mark);
            this.selectedMark = mark;
            this.creating = false;
            this.notifyMarkListeners(mark, 0);
        } else {
            this.selectedMark = this.findMark(this.pressed);
            this.selectedHandle = this.selectedMark instanceof Mark ? this.selectedMark.findHandle(this.pressed) : null;
        }
        if (this.getParent() != null) {
            this.getParent().repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.selectedMark != null && this.markAction > -1) {
            this.notifyMarkListeners(this.selectedMark, this.markAction);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int deltaWidth = e.getX() - this.pressed.x;
        int deltaHeight = e.getY() - this.pressed.y;
        this.markAction = -1;
        if (this.selectedMark instanceof Mark) {
            if (this.selectedHandle instanceof Rectangle) {
                this.selectedMark.changeSize(deltaWidth, deltaHeight);
                this.markAction = 1;
            } else {
                this.selectedMark.moveCenter(deltaWidth, deltaHeight);
                this.markAction = 2;
            }
        }
        this.pressed = e.getPoint();
        if (this.getParent() != null) {
            this.getParent().repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public void addMarkListener(MarkListener listener) {
        if (!this.markListeners.contains(listener)) {
            this.markListeners.addElement(listener);
        }
    }

    public void removeMarkListener(MarkListener listener) {
        if (this.markListeners.contains(listener)) {
            this.markListeners.removeElement(listener);
        }
    }

    public void notifyMarkListeners(Mark mark, int type) {
        int i = 0;
        while (i < this.markListeners.size()) {
            MarkListener listener = (MarkListener)this.markListeners.elementAt(i);
            switch (type) {
                case 0: {
                    listener.markCreated(new MarkEvent(mark));
                    break;
                }
                case 1: {
                    listener.markChanged(new MarkEvent(mark));
                    break;
                }
                case 2: {
                    listener.markMoved(new MarkEvent(mark));
                }
            }
            ++i;
        }
    }

    public class Mark
    extends Rectangle {
        protected int type;
        protected boolean selected;
        protected Point center;
        protected int halfWidth = 25;
        protected int halfHeight = 25;
        protected Rectangle lowerRight;

        public Mark(int type, Point point) {
            this.lowerRight = new Rectangle(0, 0, OverlayDraw.this.handleWidth, OverlayDraw.this.handleHeight);
            this.type = type;
            this.center = new Point(point);
            this.setLocation();
        }

        public void setLocation() {
            this.x = this.center.x - this.halfWidth;
            this.y = this.center.y - this.halfHeight;
            this.width = 2 * this.halfWidth;
            this.height = 2 * this.halfHeight;
            this.selected = true;
            this.lowerRight.setLocation(this.x + this.width - OverlayDraw.this.handleWidth, this.y + this.height - OverlayDraw.this.handleHeight);
        }

        public void changeSize(int deltaWidth, int deltaHeight) {
            this.halfWidth += deltaWidth;
            this.halfHeight += deltaHeight;
            if (this.halfWidth < OverlayDraw.this.handleWidth) {
                this.halfWidth = OverlayDraw.this.handleWidth;
            }
            if (this.halfHeight < OverlayDraw.this.handleHeight) {
                this.halfHeight = OverlayDraw.this.handleHeight;
            }
            this.setLocation();
        }

        public void moveCenter(int deltaWidth, int deltaHeight) {
            this.center.x += deltaWidth;
            this.center.y += deltaHeight;
            this.setLocation();
        }

        public Rectangle findHandle(Point point) {
            if (this.lowerRight.contains(point)) {
                return this.lowerRight;
            }
            return null;
        }

        protected void draw(Graphics g) {
            Color saveColor = g.getColor();
            g.setColor(OverlayDraw.this.markColor);
            switch (this.type) {
                case 0: {
                    g.drawRect(this.x, this.y, this.width, this.height);
                    break;
                }
                case 1: {
                    g.drawOval(this.x, this.y, this.width, this.height);
                }
            }
            if (OverlayDraw.this.selectedMark == this) {
                g.fillRect(this.lowerRight.x, this.lowerRight.y, OverlayDraw.this.handleWidth, OverlayDraw.this.handleHeight);
            }
            g.setColor(saveColor);
        }
    }

    public class MarkEvent
    extends EventObject {
        public MarkEvent(Object source) {
            super(source);
        }
    }

    public static interface MarkListener
    extends EventListener {
        public void markCreated(MarkEvent var1);

        public void markChanged(MarkEvent var1);

        public void markMoved(MarkEvent var1);
    }
}

