/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing.map;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import org.concord.swing.map.MapContainer;
import org.concord.swing.map.MapItem;
import org.concord.swing.map.NodeItem;

public class ArcItem
extends MapItem {
    protected static final int RADIUS = 5;
    protected Polygon arrow = new Polygon();
    protected Rectangle bounds = new Rectangle(0, 0, 0, 0);
    protected int id;
    protected Color color = Color.black;
    protected Color selectedColor = Color.red;
    protected NodeItem sourceItem;
    protected NodeItem sinkItem;
    protected Point sourcePoint = new Point(0, 0);
    protected Point sinkPoint = new Point(0, 0);
    protected Point p1 = new Point(0, 0);
    protected Point p2 = new Point(0, 0);
    protected int a = 3;
    protected int b = 4;
    protected int c = 1;
    protected int d = 2;
    protected String name;
    protected static int arcNumber = 0;

    public ArcItem(MapContainer container) {
        super(container);
    }

    @Override
    public void delete() {
        if (this.sourceItem != null) {
            this.sourceItem.removeArc(this);
        }
        if (this.sinkItem != null) {
            this.sinkItem.removeArc(this);
        }
        if (this.parent != null) {
            this.parent.removeArcItem(this);
        }
    }

    public void setSourceNode(NodeItem sourceItem) {
        if (this.sourceItem instanceof NodeItem && sourceItem == null) {
            this.setSourceLocation(this.sourceItem.getNodeCenterX(), this.sourceItem.getNodeCenterY());
        }
        this.sourceItem = sourceItem;
        if (sourceItem instanceof NodeItem) {
            sourceItem.addArc(this);
        }
        String sourceName = sourceItem == null ? "self" : sourceItem.getName();
        String sinkName = this.sinkItem == null ? "self" : this.sinkItem.getName();
        this.setName("Arc from " + sourceName + " to " + sinkName);
    }

    public NodeItem getSourceNode() {
        return this.sourceItem;
    }

    public void setSinkNode(NodeItem sinkItem) {
        if (this.sinkItem instanceof NodeItem && sinkItem == null) {
            this.setSinkLocation(this.sinkItem.getNodeCenterX(), this.sinkItem.getNodeCenterY());
        }
        this.sinkItem = sinkItem;
        if (sinkItem instanceof NodeItem) {
            sinkItem.addArc(this);
        }
        String sourceName = this.sourceItem == null ? "self" : this.sourceItem.getName();
        String sinkName = sinkItem == null ? "self" : sinkItem.getName();
        this.setName("Arc from " + sourceName + " to " + sinkName);
    }

    public NodeItem getSinkNode() {
        return this.sinkItem;
    }

    public void setArrowRatio(int num, int denom) {
        this.a = num;
        this.b = denom;
    }

    public void setImageRatio(int num, int denom) {
        this.c = num;
        this.d = denom;
    }

    public boolean isNear(int x, int y, Point point, int radius) {
        return Math.abs(x - point.x) <= radius && Math.abs(y - point.y) <= radius;
    }

    public boolean isNearSourceLocation(int x, int y) {
        return this.sourceItem == null && this.isNear(x, y, this.sourcePoint, 5);
    }

    public Point getSourcePoint() {
        return this.sourcePoint;
    }

    public void setSourceLocation(int x, int y) {
        this.sourcePoint.setLocation(x, y);
    }

    public boolean isNearSinkLocation(int x, int y) {
        return this.sinkItem == null && this.isNear(x, y, this.sinkPoint, 5);
    }

    public Point getSinkPoint() {
        return this.sinkPoint;
    }

    public void setSinkLocation(int x, int y) {
        this.sinkPoint.setLocation(x, y);
    }

    @Override
    public Rectangle getBounds() {
        if (this.image instanceof Image) {
            return this.imageBounds;
        }
        return this.bounds;
    }

    @Override
    public void translate(int x, int y) {
        if (this.sourceItem == null) {
            this.sourcePoint.translate(x, y);
        }
        if (this.sinkItem == null) {
            this.sinkPoint.translate(x, y);
        }
    }

    public void removeNode(NodeItem nodeItem) {
        if (nodeItem == this.sourceItem) {
            this.setSourceNode(null);
        }
        if (nodeItem == this.sinkItem) {
            this.setSinkNode(null);
        }
    }

    public void removeNodes() {
        if (this.sourceItem != null) {
            this.sourceItem.removeArcItem(this);
            this.sourceItem = null;
        }
        if (this.sinkItem != null) {
            this.sinkItem.removeArcItem(this);
            this.sinkItem = null;
        }
    }

    public boolean isDisconnected() {
        return this.sourceItem == null || this.sinkItem == null;
    }

    protected void transformPolygon(Point p, Point d, float angle) {
        this.bounds.x = Integer.MAX_VALUE;
        this.bounds.y = Integer.MAX_VALUE;
        this.bounds.width = Integer.MIN_VALUE;
        this.bounds.height = Integer.MIN_VALUE;
        int f = d.x > 0 ? 1 : -1;
        int i = 0;
        while (i < this.arrow.npoints) {
            float x = this.arrow.xpoints[i];
            float y = this.arrow.ypoints[i];
            float x1 = (float)((double)((float)f * x) * Math.cos(angle) + (double)y * Math.sin(angle));
            float y1 = (float)((double)x * Math.sin(angle) + (double)((float)(-f) * y) * Math.cos(angle));
            this.arrow.xpoints[i] = (int)x1;
            this.arrow.ypoints[i] = (int)y1;
            this.bounds.x = Math.min(this.arrow.xpoints[i], this.bounds.x);
            this.bounds.y = Math.min(this.arrow.ypoints[i], this.bounds.y);
            this.bounds.width = Math.max(this.arrow.xpoints[i], this.bounds.width);
            this.bounds.height = Math.max(this.arrow.ypoints[i], this.bounds.height);
            ++i;
        }
        this.bounds.width -= this.bounds.x;
        this.bounds.height -= this.bounds.y;
        this.bounds.x += p.x;
        this.bounds.y += p.y;
        i = 0;
        while (i < this.arrow.npoints) {
            int n = i;
            this.arrow.xpoints[n] = this.arrow.xpoints[n] + p.x;
            int n2 = i++;
            this.arrow.ypoints[n2] = this.arrow.ypoints[n2] + p.y;
        }
    }

    protected void setPoints() {
        Rectangle b;
        int[] nArray = new int[3];
        nArray[0] = 20;
        int[] xpts = nArray;
        int[] nArray2 = new int[3];
        nArray2[1] = 8;
        nArray2[2] = -8;
        int[] ypts = nArray2;
        this.arrow.xpoints = xpts;
        this.arrow.ypoints = ypts;
        this.arrow.npoints = this.arrow.ypoints.length;
        if (this.sourceItem == null) {
            this.p1.setLocation(this.sourcePoint);
        } else {
            b = this.sourceItem.getBounds();
            this.p1.x = b.x + b.width / 2;
            this.p1.y = b.y + b.height / 2;
        }
        if (this.sinkItem == null) {
            this.p2.setLocation(this.sinkPoint);
        } else {
            b = this.sinkItem.getBounds();
            this.p2.x = b.x + b.width / 2;
            this.p2.y = b.y + b.height / 2;
        }
    }

    public void drawConnect(Graphics g, boolean selected) {
        Color saveColor = g.getColor();
        g.setColor(selected ? this.selectedColor : this.color);
        this.setPoints();
        if (this.sourceItem == null) {
            g.fillOval(this.p1.x - 5, this.p1.y - 5, 10, 10);
        }
        g.drawLine(this.p1.x, this.p1.y, this.p2.x, this.p2.y);
        if (this.sinkItem == null) {
            g.fillOval(this.p2.x - 5, this.p2.y - 5, 10, 10);
        }
        g.setColor(saveColor);
    }

    public void draw(Graphics g, boolean selected) {
        Color saveColor = g.getColor();
        g.setColor(selected ? this.selectedColor : this.color);
        this.setPoints();
        this.p2.setLocation(this.p2.x - this.p1.x, this.p2.y - this.p1.y);
        if (this.image instanceof Image) {
            Rectangle r = this.imageBounds;
            r.setLocation(this.p1.x + this.c * this.p2.x / this.d, this.p1.y + this.c * this.p2.y / this.d);
            r.width = this.image.getWidth(this.observer);
            r.height = this.image.getHeight(this.observer);
            r.setLocation(r.x - r.width / 2, r.y - r.height / 2);
            g.drawImage(this.image, r.x, r.y, this.observer);
            FontMetrics metrics = g.getFontMetrics(g.getFont());
            this.textX = r.x + (r.width - metrics.stringWidth(this.getName())) / 2;
            this.textY = r.y + r.height + metrics.getAscent();
            g.setColor(this.textColor);
            g.drawString(this.getName(), this.textX, this.textY);
            g.setColor(selected ? this.selectedColor : this.color);
        }
        this.p1.setLocation(this.p1.x + this.a * this.p2.x / this.b, this.p1.y + this.a * this.p2.y / this.b);
        float theta = (float)Math.asin((double)this.p2.y / Math.sqrt(this.p2.y * this.p2.y + this.p2.x * this.p2.x));
        this.transformPolygon(this.p1, this.p2, theta);
        g.fillPolygon(this.arrow);
        g.setColor(saveColor);
    }

    @Override
    public int getID() {
        return this.id;
    }

    public String toString() {
        return this.name;
    }
}

