/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing.map;

import java.util.EventObject;
import java.util.Vector;
import org.concord.swing.map.MapItem;

public class MapEvent
extends EventObject {
    public static final int ITEM_SELECTED = 0;
    public static final int ITEM_MOVED = 1;
    public static final int ITEM_OPENED = 2;
    public static final int ITEM_CREATED = 3;
    public static final int ITEM_DELETED = 4;
    public static final int ITEM_POPUP = 5;
    protected Object data;
    protected int type = 0;

    public MapEvent(Object source, Object arg, int type) {
        super(source);
        this.type = type;
        this.data = arg;
    }

    public MapItem getSelection() {
        if (this.data instanceof Vector) {
            Vector selectionList = (Vector)this.data;
            return selectionList.size() == 0 ? null : (MapItem)selectionList.elementAt(0);
        }
        return null;
    }

    public boolean isSelectionEvent() {
        return this.data instanceof Vector;
    }

    public boolean isCreateEvent() {
        return this.type == 3 && this.data instanceof MapItem;
    }

    public boolean isOpenEvent() {
        return this.type == 2 && this.data instanceof MapItem;
    }

    public boolean isDeleteEvent() {
        return this.type == 4 && this.data instanceof MapItem;
    }

    public boolean isMultipleSelection() {
        return this.data instanceof Vector && ((Vector)this.data).size() > 1;
    }

    public Vector getSelectionList() {
        return (Vector)this.data;
    }

    public MapItem getMapItem() {
        return (MapItem)this.data;
    }

    public Object getData() {
        return this.data;
    }
}

