/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing.map;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;
import org.concord.swing.map.ArcItem;
import org.concord.swing.map.MapContainer;
import org.concord.swing.map.MapItem;

public class NodeItem
extends MapItem {
    protected static int itemNumber = 0;
    protected Rectangle bounds = new Rectangle(0, 0, 0, 0);
    protected String name;
    protected Point currentLocation = new Point(0, 0);
    protected Dimension defaultSize = new Dimension(50, 50);
    protected Color color = Color.cyan;
    protected Color parentColor = Color.green;
    protected Color selectedColor = Color.red;
    protected Color selectedParentColor = Color.yellow;
    protected Vector arcItems = new Vector();
    protected int id;

    public NodeItem(MapContainer container) {
        super(container);
        this.setName("node" + NodeItem.getNextItemNumber());
        this.bounds.setBounds(0, 0, this.defaultSize.width, this.defaultSize.height);
    }

    public NodeItem(MapContainer container, String name) {
        this(container);
        this.setName(name);
    }

    @Override
    public void delete() {
        Vector items = (Vector)this.arcItems.clone();
        int i = 0;
        while (i < items.size()) {
            ArcItem arcItem = (ArcItem)items.elementAt(i);
            arcItem.removeNode(this);
            ++i;
        }
        Vector subItems = (Vector)this.nestedNodeItems.clone();
        int i2 = 0;
        while (i2 < subItems.size()) {
            NodeItem nodeItem = (NodeItem)subItems.elementAt(i2);
            nodeItem.delete();
            ++i2;
        }
        subItems = (Vector)this.nestedArcItems.clone();
        i2 = 0;
        while (i2 < subItems.size()) {
            ArcItem arcItem = (ArcItem)subItems.elementAt(i2);
            arcItem.delete();
            ++i2;
        }
        if (this.parent != null) {
            this.parent.removeNodeItem(this);
        }
    }

    public void addArc(ArcItem arc) {
        this.arcItems.addElement(arc);
    }

    public void removeArc(ArcItem arc) {
        this.arcItems.removeElement(arc);
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    public void setBounds(int x, int y, int width, int height) {
        this.bounds.setBounds(x, y, width, height);
    }

    public void setSize(Dimension size) {
        this.bounds.setSize(size);
    }

    @Override
    public void translate(int x, int y) {
        this.bounds.translate(x, y);
        Point p = this.bounds.getLocation();
        p.x = Math.max(p.x, 0);
        p.y = Math.max(p.y, 0);
        this.bounds.setLocation(p);
    }

    public void setLocation(int x, int y) {
        this.bounds.setLocation(x, y);
    }

    protected int getNodeCenterX() {
        Rectangle bounds = this.getBounds();
        return bounds.x + bounds.width / 2;
    }

    protected int getNodeCenterY() {
        Rectangle bounds = this.getBounds();
        return bounds.y + bounds.height / 2;
    }

    protected Rectangle computeBounds(FontMetrics metrics) {
        Rectangle b = this.getBounds();
        if (b.width == -1 || b.height == -1) {
            int width = metrics.stringWidth(String.valueOf(this.getName()) + "  ");
            b.setSize(Math.max(this.defaultSize.width, width), this.defaultSize.height);
            return b;
        }
        this.textX = this.getNodeCenterX() - metrics.stringWidth(this.getName()) / 2;
        if (this.image instanceof Image) {
            this.textY = b.y + b.height + metrics.getAscent();
            b.setSize(this.image.getWidth(this.observer), this.defaultSize.height);
            return b;
        }
        this.textY = this.getNodeCenterY() - metrics.getHeight() / 2 + metrics.getAscent();
        int extra = 0;
        extra = this.textX < b.x ? 3 * (b.x - this.textX) : 0;
        b.setBounds(b.x - extra / 2, b.y, b.width + extra, b.height);
        return b;
    }

    public void draw(Graphics g, boolean selected) {
        Color saveColor = g.getColor();
        FontMetrics metrics = g.getFontMetrics(g.getFont());
        Rectangle b = this.computeBounds(metrics);
        if (this.nestedNodeItems.size() > 0 || this.nestedArcItems.size() > 0) {
            g.setColor(selected ? this.selectedParentColor : this.parentColor);
        } else {
            g.setColor(selected ? this.selectedColor : this.color);
        }
        if (this.image instanceof Image) {
            g.drawImage(this.image, b.x, b.y, this.observer);
        } else {
            g.fillOval(b.x, b.y, b.width, b.height);
        }
        if (this.image instanceof Image) {
            g.drawRect(b.x, b.y, b.width, b.height);
            g.setColor(this.textColor);
        } else {
            g.setColor(this.textColor);
            g.drawOval(b.x, b.y, b.width, b.height);
        }
        g.drawString(this.getName(), this.textX, this.textY);
        g.setColor(saveColor);
    }

    public static int getNextItemNumber() {
        return itemNumber++;
    }

    public static void setItemNumber(int number) {
        itemNumber = number;
    }

    public static void resetItemNumber() {
        itemNumber = 0;
    }

    @Override
    public int getID() {
        return this.id;
    }
}

