/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing.util;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.concord.swing.util.ImageWriter;

public class ComponentScreenshot {
    private static Hashtable extImageWriters = new Hashtable();

    public static void registerImageWriter(String type, ImageWriter writer) {
        extImageWriters.put(type, writer);
    }

    public static void saveImageAsFile(BufferedImage image, String filename) throws Throwable {
        ComponentScreenshot.saveImageAsFile(image, filename, "");
    }

    public static void saveImageAsFile(BufferedImage image, String filename, String type) throws Throwable {
        try {
            File file = new File(filename);
            ComponentScreenshot.saveImageAsFile(image, file, type);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void saveImageAsFile(BufferedImage image, File file, String type) throws Throwable {
        FileOutputStream fos = new FileOutputStream(file);
        if (type == null || type.equals("")) {
            ComponentScreenshot.saveImageAsOutputStream(image, fos);
        } else {
            ComponentScreenshot.saveImageAsOutputStream(image, fos, type);
        }
        fos.close();
    }

    public static void saveImageAsOutputStream(BufferedImage image, OutputStream out) throws Throwable {
        try {
            ComponentScreenshot.saveImageAsOutputStream(image, out, "png");
        }
        catch (Throwable e) {
            ComponentScreenshot.saveImageAsOutputStream(image, out, "gif");
        }
    }

    public static void saveImageAsOutputStream(BufferedImage image, OutputStream out, String type) throws Throwable {
        try {
            ImageWriter writer = (ImageWriter)extImageWriters.get(type);
            if (writer != null) {
                writer.write(image, type, out);
            } else {
                Class<?> clazz = Class.forName("javax.imageio.ImageIO");
                Method m = clazz.getMethod("write", Class.forName("java.awt.image.RenderedImage"), String.class, OutputStream.class);
                m.invoke(null, image, type, out);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void saveScreenshotAsImageFile(Component c, String filename, String type) throws Throwable {
        BufferedImage image = ComponentScreenshot.getScreenshot(c);
        ComponentScreenshot.saveImageAsFile(image, filename, type);
    }

    public static BufferedImage getScreenshot(Component c) throws Exception {
        return ComponentScreenshot.getScreenshot(c, false);
    }

    public static BufferedImage getScreenshot(Component comp, boolean includeParents) throws Exception {
        Component c = comp;
        if (includeParents) {
            while (c.getParent() != null && c.getParent() instanceof JPanel) {
                c = c.getParent();
            }
        }
        return ComponentScreenshot.makeComponentImage(c, 1.0f, 1.0f);
    }

    public static void paintScaledComponent(Graphics2D g, Component c, float xScale, float yScale) {
        g.scale(xScale, yScale);
        if (c instanceof JComponent) {
            JComponent jComp = (JComponent)c;
            boolean dBuffered = jComp.isDoubleBuffered();
            jComp.setDoubleBuffered(false);
            jComp.paint(g);
            jComp.setDoubleBuffered(dBuffered);
        } else {
            c.paint(g);
        }
    }

    public static BufferedImage makeComponentImage(Component c, float xScale, float yScale) throws Exception {
        BufferedImage image = null;
        try {
            image = new BufferedImage(c.getWidth(), c.getHeight(), 1);
            Graphics2D g = image.createGraphics();
            ComponentScreenshot.paintScaledComponent(g, c, xScale, yScale);
            g.dispose();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return image;
    }

    public static BufferedImage makeComponentImageAlpha(Component compForPicture, float xScale, float yScale) throws Exception {
        Object bim = null;
        Class<?> clazz = Class.forName("java.awt.GraphicsEnvironment");
        Method m = clazz.getMethod("getLocalGraphicsEnvironment", null);
        Object ge = m.invoke(null, null);
        m = clazz.getMethod("getDefaultScreenDevice", null);
        Object gd = m.invoke(ge, null);
        m = gd.getClass().getMethod("getDefaultConfiguration", null);
        Object gc = m.invoke(gd, null);
        m = gc.getClass().getMethod("getColorModel", null);
        ColorModel cm = (ColorModel)m.invoke(gc, null);
        boolean hasAlpha = cm.hasAlpha();
        int cw = compForPicture.getSize().width;
        int ch = compForPicture.getSize().height;
        int bw = (int)((float)cw * xScale);
        int bh = (int)((float)ch * yScale);
        if (hasAlpha) {
            m = gc.getClass().getMethod("createCompatibleImage", Integer.TYPE, Integer.TYPE);
            bim = m.invoke(gc, new Integer(bw), new Integer(bh));
        } else {
            clazz = Class.forName("java.awt.image.BufferedImage");
            Constructor<?> c = clazz.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE);
            Field f = clazz.getField("TYPE_INT_ARGB");
            int imageType = f.getInt(null);
            bim = c.newInstance(new Integer(bw), new Integer(bh), new Integer(imageType));
        }
        if (bim == null) {
            return null;
        }
        m = bim.getClass().getMethod("createGraphics", null);
        Graphics2D og = (Graphics2D)m.invoke(bim, null);
        ComponentScreenshot.paintScaledComponent(og, compForPicture, xScale, yScale);
        og.dispose();
        return (BufferedImage)bim;
    }
}

