/*
 *  Copyright (C) 2004  The Concord Consortium, Inc.,
 *  10 Concord Crossing, Concord, MA 01742
 *
 *  Web Site: http://www.concord.org
 *  Email: info@concord.org
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * END LICENSE */

package org.concord.swing;

import java.awt.Component;

import org.w3c.dom.Document;
import org.w3c.dom.Node;

public interface ComponentFramework
{   
    /**
     * For Page return JComponent
     * 
     * @param xmlNode
     * @param manager (optional)
     * @return component
     */
    Component loadComponent(Node xmlNode);
    
    Component loadComponent(Node xmlNode, Manager manager);
    
    /**
     * Return an xmlNode.
     * it is up-to the caller of this framework to not write
     * out a component twice and to track references.
     * 
     * @param component
     * @param manager (optional)
     * @return xml node
     */
    Node saveComponent(Document document, Component component);

    Node saveComponent(Document document, Component component, Manager manager);

    /**
     * Return a schema for this particular object saving in
     * this framework
     * This is something we would like but it isn't clear how it will
     * work yet
     * 
     * @param objectClass
     * @return
     */
    Object getSchema(Class objectClass);
    
    Manager registerManager(Class managerClass);
    
    interface Manager
    {
        
        Component loadComponent(Node xmlNode);

        /**
         * return an xmlNode
         * 
         * @param component
         * @return
         */
        Node saveComponent(Document document, Component component);
        
        /**
         * One way to specify these registrations is 
         * as meta data inside of the jar file
         * 
         * @param component
         * @return
         */
        boolean registerComponent(Component component);
    }
}

