/*
 * Decompiled with CFR 0.152.
 */
package de.lazyzero.NazeWiiConf;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.lazyzero.NazeWiiConf.gui.MainPanel;
import de.lazyzero.NazeWiiConf.gui.NazeBaseConfPanel;
import de.lazyzero.NazeWiiConf.gui.NazeSettingsPanel;
import de.lazyzero.NazeWiiConf.gui.NazeUploadPanel;
import de.lazyzero.NazeWiiConf.gui.widget.NazeWiiMenu;
import de.lazyzero.NazeWiiConf.gui.widget.NazeWiiPanel;
import de.lazyzero.NazeWiiConf.gui.widget.StateBar;
import de.lazyzero.NazeWiiConf.utils.Icons;
import de.lazyzero.NazeWiiConf.utils.NazeWiiLogger;
import de.lazyzero.NazeWiiConf.utils.Utils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import lu.tudor.santec.i18n.Translatrix;

public class NazeWiiConf
extends JFrame {
    public static String VERSION = "0.1";
    private boolean isBeta = true;
    private String betaVersion = "6";
    private static final long serialVersionUID = 1L;
    public static boolean isNaze = true;
    public static boolean isMWC = false;
    private NazeWiiLogger logger;
    private Locale locale;
    private Properties settings = new Properties();
    public static File SETTINGS_FILE = new File(Utils.getTempFolder(), "/NazeWiiConf.properties");
    private boolean isOffline = false;
    private StateBar stateBar;
    private NazeWiiMenu menu;
    private MainPanel mainPanel;
    private NazeWiiPanel firmwareUploadPanel;
    private NazeBaseConfPanel baseConfPanel;
    private NazeSettingsPanel settingsConfPanel;
    private static NazeWiiConf instance;

    public NazeWiiConf() {
        instance = this;
        this.logger = NazeWiiLogger.getLogger(NazeWiiConf.class.getName());
        if (Utils.isMac()) {
            SETTINGS_FILE = new File(String.valueOf(System.getProperty("user.home")) + "/Library/Preferences/", "NazeWiiConf.properties");
        }
        this.loadSettings();
        this.loadTranslation();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                NazeWiiConf.this.saveSettings();
                try {
                    NazeWiiConf.this.mainPanel.getNazeCommunicator().closeCLI();
                }
                catch (NullPointerException e) {
                    NazeWiiConf.this.logger.info("CLI already closed.");
                }
            }
        });
        this.initGUI();
    }

    private void initGUI() {
        CellConstraints cc = new CellConstraints();
        String panelColumns = "fill:pref:grow";
        String panelRows = "fill:pref:grow, 3dlu, pref";
        FormLayout panelLayout = new FormLayout(panelColumns, panelRows);
        this.setLayout((LayoutManager)panelLayout);
        this.menu = new NazeWiiMenu(this);
        this.mainPanel = new MainPanel(this);
        this.firmwareUploadPanel = new NazeUploadPanel(Translatrix._((String)"firmwarePanel.title"), this);
        this.baseConfPanel = new NazeBaseConfPanel(Translatrix._((String)"baseConfPanel.title"), this);
        this.settingsConfPanel = new NazeSettingsPanel(Translatrix._((String)"settingsConfPanel.title"), this);
        this.stateBar = new StateBar();
        this.mainPanel.addTab(this.baseConfPanel);
        this.mainPanel.addTab(this.settingsConfPanel);
        this.mainPanel.addTab(this.firmwareUploadPanel);
        this.setJMenuBar(this.menu.getBar());
        this.setIconImage(Icons.getImage("nazewiiconf.png", 16));
        this.setTitle(String.valueOf(Translatrix._((String)"NazeWiiConf")) + " " + VERSION + (this.isBeta ? " beta " + this.betaVersion : "") + " - " + (this.isOffline ? "offline" : "online"));
        this.add((Component)this.mainPanel, cc.xy(1, 1));
        this.add((Component)this.stateBar, cc.xy(1, 3));
        this.setPreferredSize(new Dimension(840, 450));
        this.pack();
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(3);
        this.setVisible(true);
        this.mainPanel.addTabChangeListener();
    }

    public static void main(String[] args) {
        new NazeWiiConf();
    }

    private void loadTranslation() {
        Translatrix.loadSupportedLocales((String)"de.lazyzero.NazeWiiConf.gui.resources.supportedLocales");
        Translatrix.setLocale((Locale)Translatrix.getDefaultLocale());
        Vector locales = Translatrix.getSupportedLocales();
        if (locales.contains(this.locale)) {
            Translatrix.setLocale((Locale)this.locale);
        } else {
            this.locale = Translatrix.getLocale();
        }
        Translatrix.addBundle((String)"de.lazyzero.NazeWiiConf.gui.resources.translatrix");
    }

    public void loadSettings() {
        try {
            this.settings.load(new FileInputStream(SETTINGS_FILE));
            try {
                this.setLocale(this.settings.getProperty("locale.language", "en"), this.settings.getProperty("locale.country", "US"));
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            this.saveSettings();
            this.logger.log(Level.INFO, e.getMessage());
            e.printStackTrace();
        }
    }

    private void saveSettings() {
        try {
            if (!SETTINGS_FILE.mkdir()) {
                // empty if block
            }
            this.settings.put("locale.language", this.locale.getLanguage());
            this.settings.put("locale.country", this.locale.getCountry());
            this.settings.store(new FileOutputStream(SETTINGS_FILE), "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static NazeWiiConf getInstance() {
        return instance;
    }

    public NazeWiiLogger getLogger() {
        return this.logger;
    }

    public boolean isOffline() {
        return this.isOffline;
    }

    public void setOffline(boolean isOffline) {
        this.isOffline = isOffline;
        this.setTitle(String.valueOf(Translatrix._((String)"NazeWiiConf")) + " " + VERSION + (this.isBeta ? " beta " + this.betaVersion : "") + " - " + (isOffline ? "offline" : "online"));
    }

    public void setLocale(String language, String country) {
        this.locale = new Locale(language, country);
        this.logger.log(Level.INFO, String.valueOf(language) + "_" + country);
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    public boolean restart() {
        int response = JOptionPane.showConfirmDialog(this, Translatrix._((String)"restart.dialog"), Translatrix._((String)"restart.title"), 0);
        return response == 0;
    }

    public MainPanel getMainPanel() {
        return this.mainPanel;
    }

    public String getPort() {
        return this.mainPanel.getPort();
    }

    public int getBuadrate() {
        return this.mainPanel.getBaudrate();
    }
}

