/*
 * Decompiled with CFR 0.152.
 */
package de.lazyzero.NazeWiiConf.gui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.lazyzero.NazeWiiConf.NazeWiiConf;
import de.lazyzero.NazeWiiConf.gui.NazeBaseConfPanel;
import de.lazyzero.NazeWiiConf.gui.NazeSettingsPanel;
import de.lazyzero.NazeWiiConf.gui.widget.NazeWiiPanel;
import de.lazyzero.NazeWiiConf.utils.NazeCommunicator;
import de.lazyzero.NazeWiiConf.utils.NazeConfiguration;
import de.lazyzero.NazeWiiConf.utils.NazePort;
import de.lazyzero.NazeWiiConf.utils.NazeWiiLogger;
import de.lazyzero.NazeWiiConf.utils.PortScanner;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import lu.tudor.santec.i18n.Translatrix;

public class MainPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private int baudrate = 115200;
    private NazeWiiConf nazeWiiConf;
    private NazeWiiLogger logger;
    private JLabel serialSelectLabel;
    private JButton serialConnectButton;
    private Vector<String> availablePorts = new Vector();
    private JComboBox serialConnectionComboBox;
    private JTabbedPane tabbedPane;
    private NazePort np;
    private NazeBaseConfPanel nazeBaseConfPanel;
    private NazeConfiguration nazeConfiguration;
    private NazeCommunicator nazeCommunicator;
    private Vector<NazeWiiPanel> nazeWiiPanels = new Vector();
    protected int selectedTab;
    private NazeSettingsPanel nazeSettingsPanel;
    protected static final int BASECONFTAB = 0;
    protected static final int SETTINGSTAB = 1;
    protected static final int UPDATETAB = 2;

    public MainPanel(NazeWiiConf nazeWiiConf) {
        this.nazeWiiConf = nazeWiiConf;
        this.nazeConfiguration = new NazeConfiguration();
        this.logger = this.nazeWiiConf.getLogger();
        this.initGui();
        this.updateSerialPorts();
    }

    private void initGui() {
        CellConstraints cc = new CellConstraints();
        String panelColumns = "3dlu, pref, 3dlu, pref, 3dlu, pref, fill:pref:grow, 3dlu";
        String panelRows = "3dlu, pref, 3dlu, fill:pref:grow";
        FormLayout panelLayout = new FormLayout(panelColumns, panelRows);
        this.setLayout((LayoutManager)panelLayout);
        this.availablePorts = PortScanner.listSerialPorts();
        this.serialSelectLabel = new JLabel(String.valueOf(Translatrix._((String)"serial.selectLabel")) + ":");
        this.serialConnectButton = new JButton(Translatrix._((String)"serial.connect"));
        this.serialConnectionComboBox = new JComboBox<String>(this.availablePorts);
        this.tabbedPane = new JTabbedPane();
        this.add((Component)this.serialSelectLabel, cc.xy(2, 2));
        this.add((Component)this.serialConnectionComboBox, cc.xy(4, 2));
        this.add((Component)this.serialConnectButton, cc.xy(6, 2));
        this.add((Component)this.tabbedPane, cc.xyw(1, 4, 8));
        this.serialConnectButton.addActionListener(this);
    }

    public void addTab(NazeWiiPanel tab) {
        this.nazeWiiPanels.add(tab);
        this.tabbedPane.add(tab.getTitle(), new JScrollPane(tab));
    }

    public void addTabChangeListener() {
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                JTabbedPane pane = (JTabbedPane)evt.getSource();
                MainPanel.this.selectedTab = pane.getSelectedIndex();
                switch (MainPanel.this.selectedTab) {
                    case 0: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
            }
        });
    }

    public NazeConfiguration getNazeConfiguration() {
        return this.nazeConfiguration;
    }

    public NazeCommunicator getNazeCommunicator() {
        return this.nazeCommunicator;
    }

    @Override
    public void actionPerformed(ActionEvent action) {
        if (action.getSource().equals(this.serialConnectButton)) {
            this.openPort(true);
        }
    }

    public void openPort(boolean buttonPressed) {
        block7: {
            if (this.np == null) {
                this.np = new NazePort((String)this.serialConnectionComboBox.getSelectedItem(), 115200);
                this.nazeConfiguration = new NazeConfiguration();
            }
            if (!NazeWiiConf.isNaze) break block7;
            for (NazeWiiPanel tab : this.nazeWiiPanels) {
                if (tab instanceof NazeBaseConfPanel) {
                    this.nazeBaseConfPanel = (NazeBaseConfPanel)tab;
                    continue;
                }
                if (!(tab instanceof NazeSettingsPanel)) continue;
                this.nazeSettingsPanel = (NazeSettingsPanel)tab;
            }
            if ((this.np.isPortOpened() || buttonPressed) && (this.selectedTab == 0 || this.selectedTab == 1)) {
                this.nazeBaseConfPanel.enableAllButtons(false);
                this.nazeSettingsPanel.enableAllButtons(false);
                this.nazeCommunicator = new NazeCommunicator(this.nazeBaseConfPanel, this.nazeSettingsPanel, this.nazeConfiguration, this.np);
                this.nazeCommunicator.setListener(this.nazeCommunicator);
                try {
                    if (!this.np.isPortOpened()) {
                        this.np.openPort();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.nazeCommunicator.start();
                this.nazeCommunicator.openCLI();
                this.sleep(300);
                this.nazeCommunicator.readFeatureList();
                this.sleep(300);
                this.nazeCommunicator.readMixerList();
                this.sleep(300);
                this.nazeCommunicator.readMap();
                this.sleep(50);
                this.nazeCommunicator.readSettings();
                this.sleep(300);
                this.nazeCommunicator.readEnabledFeatures();
                this.sleep(150);
                this.nazeCommunicator.readEnabledMixer();
                this.sleep(150);
                this.nazeCommunicator.readStatus();
                this.sleep(150);
                this.nazeCommunicator.readVersion();
                this.sleep(150);
                this.nazeBaseConfPanel.enableAllButtons(true);
                this.nazeSettingsPanel.enableAllButtons(true);
                this.logger.log(Level.INFO, Translatrix._((String)"baseConfPanel.mainPanel.settingsLoad"), true);
            }
        }
    }

    private void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void closeSerialPort() throws IOException, NullPointerException {
        this.nazeCommunicator.closeCLI();
        this.np.close();
        this.nazeBaseConfPanel.enableAllButtons(false);
    }

    public String getPort() {
        return (String)this.serialConnectionComboBox.getSelectedItem();
    }

    public int getBaudrate() {
        return this.baudrate;
    }

    public NazeSettingsPanel getNazeSettingsPanel() {
        return this.nazeSettingsPanel;
    }

    private void updateSerialPorts() {
        Thread t = new Thread(){

            @Override
            public void run() {
                while (true) {
                    String selectedItem = (String)MainPanel.this.serialConnectionComboBox.getSelectedItem();
                    Vector<String> list = PortScanner.listSerialPorts();
                    for (String port : list) {
                        if (MainPanel.this.availablePorts.contains(port)) continue;
                        System.out.println("add port to list: " + port);
                        MainPanel.this.availablePorts.add(port);
                        MainPanel.this.serialConnectionComboBox.setModel(new DefaultComboBoxModel(MainPanel.this.availablePorts));
                        MainPanel.this.serialConnectionComboBox.setSelectedItem(selectedItem);
                    }
                    try {
                        2.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        };
        t.start();
    }
}

