/*
 * Decompiled with CFR 0.152.
 */
package de.lazyzero.NazeWiiConf.gui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.lazyzero.NazeWiiConf.NazeWiiConf;
import de.lazyzero.NazeWiiConf.gui.widget.FeatureConfWidget;
import de.lazyzero.NazeWiiConf.gui.widget.MapConfWidget;
import de.lazyzero.NazeWiiConf.gui.widget.MixerConfWidget;
import de.lazyzero.NazeWiiConf.gui.widget.NazeWiiPanel;
import de.lazyzero.NazeWiiConf.gui.widget.StatusWidget;
import de.lazyzero.NazeWiiConf.gui.widget.VersionWidget;
import de.lazyzero.NazeWiiConf.utils.NazeConfiguration;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JButton;
import lu.tudor.santec.i18n.Translatrix;

public class NazeBaseConfPanel
extends NazeWiiPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JButton resetDefaultsButton;
    private JButton cancelSettingsButton;
    private JButton saveSettingsButton;
    private MixerConfWidget mixerConfWidget;
    private NazeConfiguration nazeConfiguration;
    private FeatureConfWidget featureConfWidget;
    private VersionWidget versionWidget;
    private StatusWidget statusWidget;
    private MapConfWidget mapConfWidget;

    public NazeBaseConfPanel(String title, NazeWiiConf instance) {
        super(title, instance);
        this.initGUI();
    }

    private void initGUI() {
        CellConstraints cc = new CellConstraints();
        String panelColumns = "pref:grow(5), 3dlu, pref:grow(5), 3dlu, pref:grow(2), 3dlu, fill:pref:grow(2)";
        String panelRows = "pref:grow(6), 3dlu, pref, 3dlu, pref, 3dlu, fill:pref:grow(6), 3dlu, pref";
        FormLayout panelLayout = new FormLayout(panelColumns, panelRows);
        this.setLayout((LayoutManager)panelLayout);
        this.mixerConfWidget = new MixerConfWidget(Translatrix._((String)"baseConfPanel.mixerConfWidget.title"), this.instance);
        this.featureConfWidget = new FeatureConfWidget(Translatrix._((String)"baseConfPanel.featureConfWidget.title"), this.instance);
        this.mapConfWidget = new MapConfWidget(Translatrix._((String)"baseConfPanel.mapConfWidget.title"), this.instance);
        this.versionWidget = new VersionWidget(Translatrix._((String)"baseConfPanel.versionWidget.title"), this.instance);
        this.statusWidget = new StatusWidget(Translatrix._((String)"baseConfPanel.statusWidget.title"), this.instance);
        this.resetDefaultsButton = new JButton(Translatrix._((String)"baseConfPanel.resetDefaultsButton"));
        this.saveSettingsButton = new JButton(Translatrix._((String)"baseConfPanel.saveSettingsButton"));
        this.cancelSettingsButton = new JButton(Translatrix._((String)"baseConfPanel.cancelSettingsButton"));
        this.cancelSettingsButton.addActionListener(this);
        this.saveSettingsButton.addActionListener(this);
        this.resetDefaultsButton.addActionListener(this);
        this.add((Component)this.resetDefaultsButton, cc.xyw(5, 3, 3));
        this.add((Component)this.saveSettingsButton, cc.xy(5, 5));
        this.add((Component)this.cancelSettingsButton, cc.xy(7, 5));
        this.add((Component)this.mixerConfWidget, cc.xywh(1, 1, 1, 7));
        this.add((Component)this.featureConfWidget, cc.xywh(3, 1, 1, 7));
        this.add((Component)this.mapConfWidget, cc.xywh(5, 1, 3, 1));
        this.add((Component)this.statusWidget, cc.xywh(5, 7, 3, 1));
        this.add((Component)this.versionWidget, cc.xyw(1, 9, 7));
        this.enableAllButtons(false);
    }

    public void updateMixers() {
        this.nazeConfiguration = this.instance.getMainPanel().getNazeConfiguration();
        this.mixerConfWidget.addMixers(this.nazeConfiguration.getMixers());
    }

    public void updateSelectedMixer() {
        this.nazeConfiguration = this.instance.getMainPanel().getNazeConfiguration();
        this.mixerConfWidget.setSelectedMixer(this.nazeConfiguration.getEnabledMixer());
    }

    public void updateEnabledFeatures() {
        this.nazeConfiguration = this.instance.getMainPanel().getNazeConfiguration();
        this.featureConfWidget.setEnabledFeatures(this.nazeConfiguration.getEnabledFeatures());
    }

    public void updateFeatures() {
        this.nazeConfiguration = this.instance.getMainPanel().getNazeConfiguration();
        this.featureConfWidget.addFeatures(this.nazeConfiguration.getFeatures());
    }

    public void updateVersion() {
        this.nazeConfiguration = this.instance.getMainPanel().getNazeConfiguration();
        this.versionWidget.updateVersion(this.nazeConfiguration.getVersion());
    }

    public void updateStatus() {
        this.nazeConfiguration = this.instance.getMainPanel().getNazeConfiguration();
        this.statusWidget.updateStatus(this.nazeConfiguration);
    }

    public void updateMap() {
        this.nazeConfiguration = this.instance.getMainPanel().getNazeConfiguration();
        this.mapConfWidget.updateMap(this.nazeConfiguration.getMap());
    }

    @Override
    public void actionPerformed(ActionEvent action) {
        if (action.getSource().equals(this.cancelSettingsButton)) {
            try {
                this.instance.getMainPanel().closeSerialPort();
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.instance.getMainPanel().openPort(true);
        } else if (action.getSource().equals(this.saveSettingsButton)) {
            this.instance.getMainPanel().getNazeCommunicator().closeCLI();
            this.sleep(1000);
            this.instance.getMainPanel().openPort(true);
        } else if (action.getSource().equals(this.resetDefaultsButton)) {
            this.instance.getMainPanel().getNazeCommunicator().writeDefaults();
            this.sleep(1000);
            this.instance.getMainPanel().openPort(true);
        }
    }

    private void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void enableAllButtons(boolean b) {
        this.cancelSettingsButton.setEnabled(b);
        this.resetDefaultsButton.setEnabled(b);
        this.saveSettingsButton.setEnabled(b);
    }
}

