/*
 * Decompiled with CFR 0.152.
 */
package de.lazyzero.NazeWiiConf.gui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.lazyzero.NazeWiiConf.NazeWiiConf;
import de.lazyzero.NazeWiiConf.gui.widget.NazeWiiPanel;
import de.lazyzero.NazeWiiConf.utils.Firmware;
import de.lazyzero.NazeWiiConf.utils.NazeWiiLogger;
import de.lazyzero.NazeWiiConf.utils.ProgressListener;
import de.lazyzero.NazeWiiConf.utils.STMLoader;
import de.lazyzero.NazeWiiConf.utils.SVN;
import de.lazyzero.NazeWiiConf.utils.Utils;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.TreeMap;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import lu.tudor.santec.i18n.Translatrix;

public class NazeUploadPanel
extends NazeWiiPanel
implements ActionListener,
ProgressListener {
    private static final long serialVersionUID = 1L;
    private SVN svn;
    private String svnURL = "http://afrodevices.googlecode.com/svn";
    private String svnFile = "/trunk/baseflight/obj/baseflight.hex";
    private SimpleDateFormat sdf = new SimpleDateFormat("dd MMMM yyyy");
    private NazeWiiLogger logger = NazeWiiConf.getInstance().getLogger();
    private JLabel revisionLabel;
    private JComboBox revisionComboBox;
    private JButton refreshButton;
    private JLabel authorTitleLabel;
    private JLabel authorLabel;
    private JLabel dateTitleLabel;
    private JLabel dateLabel;
    private JLabel descriptionArea;
    private JScrollPane descriptionPane;
    private JProgressBar progressBar;
    private JButton uploadButton;
    private TreeMap<Long, Firmware> firmwares;
    private Firmware revision;
    protected int count;
    protected int errorcount;
    private STMLoader stmLoader;

    public NazeUploadPanel(String title, NazeWiiConf instance) {
        super(title, instance);
        this.stmLoader = new STMLoader(instance, this);
        this.initGUI();
    }

    private void initGUI() {
        CellConstraints cc = new CellConstraints();
        String panelColumns = "pref, 3dlu, pref:grow(6), 3dlu, pref, 3dlu, pref:grow(6), pref, fill:pref:grow, 3dlu, pref";
        String panelRows = "pref, 3dlu, pref, 3dlu, fill:pref:grow, 3dlu, pref";
        FormLayout panelLayout = new FormLayout(panelColumns, panelRows);
        this.setLayout((LayoutManager)panelLayout);
        this.revisionLabel = new JLabel(String.valueOf(Translatrix._((String)"firmwarePanel.revision")) + ": ");
        this.revisionComboBox = new JComboBox();
        this.revisionComboBox.addItem(Translatrix._((String)"firmwarePanel.updateList"));
        this.revisionComboBox.setSelectedIndex(0);
        this.revisionComboBox.addActionListener(this);
        this.setRefreshButton(new JButton(Translatrix._((String)"firmwarePanel.refreshButton")));
        this.getRefreshButton().addActionListener(this);
        this.authorTitleLabel = new JLabel(String.valueOf(Translatrix._((String)"firmwarePanel.author")) + ": ");
        this.authorLabel = new JLabel(Translatrix._((String)"na"));
        this.dateTitleLabel = new JLabel(String.valueOf(Translatrix._((String)"firmwarePanel.date")) + ": ");
        this.dateLabel = new JLabel(Translatrix._((String)"na"));
        this.descriptionArea = new JLabel();
        this.descriptionArea.setVerticalAlignment(1);
        this.descriptionPane = new JScrollPane(this.descriptionArea);
        this.descriptionPane.setVerticalScrollBarPolicy(20);
        this.descriptionPane.setBorder(new TitledBorder(String.valueOf(Translatrix._((String)"firmwarePanel.description")) + ": "));
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setForeground(Color.blue);
        this.setUploadButton(new JButton(Translatrix._((String)"firmwarePanel.uploadButton")));
        this.getUploadButton().setEnabled(false);
        this.getUploadButton().addActionListener(this);
        this.add((Component)this.revisionLabel, cc.xy(1, 1));
        this.add((Component)this.revisionComboBox, cc.xyw(3, 1, 5));
        this.add((Component)this.getRefreshButton(), cc.xy(8, 1));
        this.add((Component)this.authorTitleLabel, cc.xy(1, 3));
        this.add((Component)this.authorLabel, cc.xy(3, 3));
        this.add((Component)this.dateTitleLabel, cc.xy(5, 3));
        this.add((Component)this.dateLabel, cc.xy(7, 3));
        this.add((Component)this.descriptionPane, cc.xyw(1, 5, 11));
        this.add((Component)this.progressBar, cc.xyw(1, 7, 9));
        this.add((Component)this.getUploadButton(), cc.xy(11, 7));
    }

    @Override
    public void actionPerformed(ActionEvent action) {
        if (action.getSource().equals(this.getRefreshButton())) {
            try {
                this.updateProgress(0);
                this.getUploadButton().setEnabled(false);
                this.svn = new SVN(this.svnURL, this.svnFile);
                this.logger.log(Level.INFO, "SVN fetched.");
                this.instance.setOffline(false);
                this.revisionComboBox.removeAllItems();
                this.firmwares = this.svn.getFirmwares();
                NavigableSet<Long> keys = this.firmwares.descendingKeySet();
                System.out.println(keys.size());
                Iterator key = keys.iterator();
                while (key.hasNext()) {
                    long rev = (Long)key.next();
                    Firmware firmware = this.firmwares.get(rev);
                    this.revisionComboBox.addItem(firmware.toString());
                }
                if (Utils.isLinux() || Utils.isMac()) {
                    this.getUploadButton().setEnabled(true);
                }
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, e.getMessage());
                this.instance.setOffline(true);
                this.getUploadButton().setEnabled(false);
            }
        } else if (action.getSource().equals(this.revisionComboBox)) {
            String item = (String)this.revisionComboBox.getSelectedItem();
            if (item != null && !item.equals(Translatrix._((String)"firmwarePanel.updateList"))) {
                String[] sItem = item.split(": ");
                String rev = sItem[0].trim().replace('r', ' ');
                rev = rev.trim();
                this.revision = this.firmwares.get(Long.parseLong(rev));
                this.authorLabel.setText(this.revision.getAuthor());
                this.dateLabel.setText(String.valueOf(this.sdf.format(this.revision.getDate())));
                this.descriptionArea.setText(this.revision.getMessage());
                this.logger.log(Level.INFO, "Revision r" + rev + " selected.");
            }
        } else if (action.getSource().equals(this.getUploadButton())) {
            this.updateProgress(0);
            this.getRefreshButton().setEnabled(false);
            this.svn.getFirmware(this.revision.getRevision());
            this.updateProgress(10);
            try {
                this.instance.getMainPanel().closeSerialPort();
            }
            catch (IOException e) {
                this.logger.log(Level.WARNING, Translatrix._((String)"nazeUploadPanel.unable2ClosePort"), true);
                e.printStackTrace();
            }
            catch (NullPointerException e) {
                this.logger.log(Level.INFO, "port already closed");
            }
            new Thread(){

                @Override
                public void run() {
                    try {
                        NazeUploadPanel.this.stmLoader.flashFirmware(NazeUploadPanel.this.revision);
                    }
                    catch (IOException e) {
                        NazeUploadPanel.this.logger.log(Level.WARNING, Translatrix._((String)"nazeUploadPanel.flashFeiled"), true);
                        NazeUploadPanel.this.logger.log(Level.WARNING, e.getMessage());
                        e.printStackTrace();
                    }
                }
            }.start();
        }
    }

    @Override
    public void updateProgress(final int value) {
        System.err.println("value: +" + value);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                System.err.println("progress: " + value);
                NazeUploadPanel.this.progressBar.setValue(value);
            }
        });
    }

    @Override
    public void updateProgressBy(final int value) {
        System.err.println("by: +" + value);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                System.err.println("progress: " + value);
                NazeUploadPanel.this.progressBar.setValue(NazeUploadPanel.this.progressBar.getValue() + value);
            }
        });
    }

    public JButton getRefreshButton() {
        return this.refreshButton;
    }

    public void setRefreshButton(JButton refreshButton) {
        this.refreshButton = refreshButton;
    }

    public JButton getUploadButton() {
        return this.uploadButton;
    }

    public void setUploadButton(JButton uploadButton) {
        this.uploadButton = uploadButton;
    }
}

