/*
 * Decompiled with CFR 0.152.
 */
package de.lazyzero.NazeWiiConf.gui.widget;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.lazyzero.NazeWiiConf.NazeWiiConf;
import de.lazyzero.NazeWiiConf.gui.widget.NazeConfWidget;
import de.lazyzero.NazeWiiConf.utils.NazeWiiLogger;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.JCheckBox;
import lu.tudor.santec.i18n.Translatrix;

public class FeatureConfWidget
extends NazeConfWidget
implements ItemListener {
    private NazeWiiLogger logger;
    private Vector<JCheckBox> checkboxes = new Vector();
    private boolean isGUIupdate = false;
    private static final long serialVersionUID = 1L;

    public FeatureConfWidget(String title, NazeWiiConf instance) {
        super(title, instance);
        this.logger = instance.getLogger();
        this.initGUI();
    }

    @Override
    protected void initGUI() {
        this.cc = new CellConstraints();
    }

    public void addFeatures(Vector<String> features) {
        System.err.println("features");
        String columnSpec = "pref:grow, 3dlu, pref:grow";
        String rowSpec = "pref, 3dlu";
        int i = 0;
        while (i < features.size() / 2 - 1) {
            rowSpec = rowSpec.concat(", pref, 3dlu");
            ++i;
        }
        rowSpec = rowSpec.concat(", pref");
        this.panelLayout = new FormLayout(columnSpec, rowSpec);
        this.setLayout((LayoutManager)this.panelLayout);
        for (JCheckBox c : this.checkboxes) {
            this.remove(c);
        }
        this.checkboxes.clear();
        int j = 0;
        int i2 = 0;
        while (i2 < features.size()) {
            if (j == 2) {
                j = 0;
            }
            JCheckBox checkbox = new JCheckBox(features.get(i2));
            checkbox.setName(features.get(i2));
            checkbox.addItemListener(this);
            this.checkboxes.add(checkbox);
            this.add((Component)checkbox, this.cc.xy(2 * j + 1, 1 + i2 - j));
            ++j;
            ++i2;
        }
        this.validate();
        this.logger.log(Level.INFO, Translatrix._((String)"baseConfPanel.featureConfWidget.featuresLoad"), true);
    }

    @Override
    public void itemStateChanged(ItemEvent item) {
        if (this.isGUIupdate) {
            return;
        }
        if (item.getStateChange() == 1) {
            System.err.println(String.valueOf(((JCheckBox)item.getSource()).getName()) + " selected");
            this.instance.getMainPanel().getNazeConfiguration().updateEnabledFeature(((JCheckBox)item.getSource()).getName(), ((JCheckBox)item.getSource()).isSelected());
            this.instance.getMainPanel().getNazeCommunicator().writeFeature(((JCheckBox)item.getSource()).getName());
        } else if (item.getStateChange() == 2) {
            System.err.println(String.valueOf(((JCheckBox)item.getSource()).getName()) + " de-selected");
            this.instance.getMainPanel().getNazeConfiguration().updateEnabledFeature(((JCheckBox)item.getSource()).getName(), ((JCheckBox)item.getSource()).isSelected());
            this.instance.getMainPanel().getNazeCommunicator().writeFeature("-" + ((JCheckBox)item.getSource()).getName());
        }
    }

    public void setEnabledFeatures(Vector<String> enabledFeatures) {
        System.err.println("enabled features: " + enabledFeatures);
        this.isGUIupdate = true;
        for (JCheckBox checkbox : this.checkboxes) {
            if (enabledFeatures.contains(checkbox.getName())) {
                checkbox.setSelected(true);
                continue;
            }
            checkbox.setSelected(false);
        }
        this.isGUIupdate = false;
    }
}

