/*
 * Decompiled with CFR 0.152.
 */
package de.lazyzero.NazeWiiConf.gui.widget;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.lazyzero.NazeWiiConf.NazeWiiConf;
import de.lazyzero.NazeWiiConf.gui.widget.NazeConfWidget;
import de.lazyzero.NazeWiiConf.utils.NazeWiiLogger;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import lu.tudor.santec.i18n.Translatrix;

public class MapConfWidget
extends NazeConfWidget
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private NazeWiiLogger logger;
    private JTextField mapField;
    private JButton writeButton;
    private JButton jrButton;
    private JButton futabaButton;
    private JButton mpxButton;
    private JButton hitecButton;

    public MapConfWidget(String title, NazeWiiConf instance) {
        super(title, instance);
        this.logger = instance.getLogger();
        this.initGUI();
    }

    @Override
    protected void initGUI() {
        this.cc = new CellConstraints();
        String columnSpec = "pref:grow, 3dlu, pref:grow";
        String rowSpec = "pref, 3dlu, pref, 5dlu, pref, 3dlu, pref";
        int[][] groups = new int[][]{{1, 3}};
        this.panelLayout = new FormLayout(columnSpec, rowSpec);
        this.panelLayout.setColumnGroups((int[][])groups);
        this.setLayout((LayoutManager)this.panelLayout);
        this.mapField = new JTextField();
        this.writeButton = new JButton(Translatrix._((String)"baseConfPanel.mapConfWidget.writeButton"));
        this.jrButton = new JButton("JR/Spektrum");
        this.futabaButton = new JButton("Futaba");
        this.mpxButton = new JButton("MPX");
        this.hitecButton = new JButton("Hitec");
        this.jrButton.addActionListener(this);
        this.futabaButton.addActionListener(this);
        this.mpxButton.addActionListener(this);
        this.hitecButton.addActionListener(this);
        this.writeButton.addActionListener(this);
        this.add((Component)this.mapField, this.cc.xy(1, 1));
        this.add((Component)this.writeButton, this.cc.xy(3, 1));
        this.add((Component)new JSeparator(), this.cc.xyw(1, 3, 3));
        this.add((Component)this.jrButton, this.cc.xy(1, 5));
        this.add((Component)this.futabaButton, this.cc.xy(3, 5));
        this.add((Component)this.mpxButton, this.cc.xy(1, 7));
        this.add((Component)this.hitecButton, this.cc.xy(3, 7));
    }

    public void updateMap(String map) {
        this.mapField.setText(map);
    }

    @Override
    public void actionPerformed(ActionEvent action) {
        if (action.getSource().equals(this.writeButton)) {
            this.instance.getMainPanel().getNazeConfiguration().setMap(this.mapField.getText());
            this.instance.getMainPanel().getNazeCommunicator().writeMap(this.mapField.getText());
        } else if (action.getSource().equals(this.futabaButton)) {
            this.mapField.setText("AETR1234");
        } else if (action.getSource().equals(this.jrButton)) {
            this.mapField.setText("TAER1234");
        } else if (action.getSource().equals(this.hitecButton)) {
            this.mapField.setText("AETR1234");
        } else if (action.getSource().equals(this.mpxButton)) {
            this.mapField.setText("AERT1234");
        }
    }
}

