/*
 * Decompiled with CFR 0.152.
 */
package de.lazyzero.NazeWiiConf.gui.widget;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.lazyzero.NazeWiiConf.NazeWiiConf;
import de.lazyzero.NazeWiiConf.gui.widget.NazeConfWidget;
import de.lazyzero.NazeWiiConf.utils.NazeWiiLogger;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import lu.tudor.santec.i18n.Translatrix;

public class MixerConfWidget
extends NazeConfWidget
implements ItemListener {
    private NazeWiiLogger logger;
    private ButtonGroup buttonGroup;
    private boolean isGUIupdate = false;
    private HashMap<String, JRadioButton> buttons = new HashMap();
    private static final long serialVersionUID = 1L;

    public MixerConfWidget(String title, NazeWiiConf instance) {
        super(title, instance);
        this.logger = instance.getLogger();
        this.initGUI();
    }

    @Override
    protected void initGUI() {
        this.cc = new CellConstraints();
    }

    public void addMixers(Vector<String> mixers) {
        System.err.println("mixer");
        String columnSpec = "pref:grow, 3dlu, pref:grow";
        String rowSpec = "pref, 3dlu";
        int i = 0;
        while (i < mixers.size() / 2 - 1) {
            rowSpec = rowSpec.concat(", pref, 3dlu");
            ++i;
        }
        rowSpec = rowSpec.concat(", pref");
        this.panelLayout = new FormLayout(columnSpec, rowSpec);
        this.setLayout((LayoutManager)this.panelLayout);
        this.buttonGroup = new ButtonGroup();
        for (JRadioButton b : this.buttons.values()) {
            this.remove(b);
        }
        this.buttons.clear();
        int j = 0;
        int i2 = 0;
        while (i2 < mixers.size()) {
            if (j == 2) {
                j = 0;
            }
            JRadioButton radio = new JRadioButton(mixers.get(i2));
            radio.setName(mixers.get(i2));
            radio.addItemListener(this);
            this.buttons.put(mixers.get(i2), radio);
            this.buttonGroup.add(radio);
            this.add((Component)radio, this.cc.xy(2 * j + 1, 1 + i2 - j));
            ++j;
            ++i2;
        }
        this.logger.log(Level.INFO, Translatrix._((String)"baseConfPanel.mixerConfWidget.mixersLoad"), true);
        this.validate();
    }

    @Override
    public void itemStateChanged(ItemEvent item) {
        if (this.isGUIupdate) {
            return;
        }
        if (item.getStateChange() == 1) {
            System.err.println(String.valueOf(((JRadioButton)item.getSource()).getName()) + " selected");
            this.instance.getMainPanel().getNazeConfiguration().setEnabledMixer(((JRadioButton)item.getSource()).getName());
            this.instance.getMainPanel().getNazeCommunicator().writeMixer(((JRadioButton)item.getSource()).getName());
        } else if (item.getStateChange() == 2) {
            System.err.println(String.valueOf(((JRadioButton)item.getSource()).getName()) + " de-selected");
        }
    }

    public void setSelectedMixer(String enabledMixer) {
        System.err.println("mixer: " + enabledMixer);
        this.isGUIupdate = true;
        this.buttons.get(enabledMixer).setSelected(true);
        this.isGUIupdate = false;
    }
}

