/*
 * Decompiled with CFR 0.152.
 */
package de.lazyzero.NazeWiiConf.gui.widget;

import de.lazyzero.NazeWiiConf.NazeWiiConf;
import de.lazyzero.NazeWiiConf.utils.Icons;
import de.lazyzero.NazeWiiConf.utils.NazeWiiLogger;
import de.lazyzero.NazeWiiConf.utils.SendLogFile;
import de.lazyzero.NazeWiiConf.utils.Utils;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Scanner;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import lu.tudor.santec.i18n.Translatrix;

public class NazeWiiMenu
extends JMenuBar {
    private static final long serialVersionUID = 1L;
    private JMenu setup;
    private JMenu info;
    private JMenu help;
    private JMenuBar bar;
    private NazeWiiConf parent;

    public NazeWiiMenu(NazeWiiConf parent) {
        this.parent = parent;
        this.initSetupMenu();
        this.initHelpMenu();
        this.initInfoMenu();
        this.bar = new JMenuBar();
        this.bar.add(this.setup);
        this.bar.add(this.help);
        this.bar.add(this.info);
    }

    public JMenuBar getBar() {
        return this.bar;
    }

    private void initHelpMenu() {
        this.help = new JMenu(Translatrix._((String)"help"));
        this.help.setMnemonic(Translatrix._((String)"help.key").charAt(0));
        JMenuItem mailItem = new JMenuItem(Translatrix._((String)"help.mail"));
        mailItem.setMnemonic(Translatrix._((String)"help.mail.key").charAt(0));
        mailItem.setIcon(Icons.getIcon22("mail.png"));
        this.help.add(mailItem);
        mailItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SendLogFile slf = new SendLogFile();
                slf.sendMail(NazeWiiConf.VERSION, NazeWiiLogger.LOG_FILE);
            }
        });
        this.help.addSeparator();
        JMenuItem helpItem = new JMenuItem(Translatrix._((String)"help"));
        helpItem.setMnemonic(Translatrix._((String)"help.help.key").charAt(0));
        helpItem.setIcon(Icons.getIcon22("LZ.png"));
        this.help.add(helpItem);
        helpItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NazeWiiMenu.openURL("http://www.lazyzero.de/en/modellbau/nazewiiconf");
            }
        });
    }

    private void initInfoMenu() {
        this.info = new JMenu(Translatrix._((String)"info"));
        this.info.setMnemonic(Translatrix._((String)"info.key").charAt(0));
        JMenuItem licenseItem = new JMenuItem(Translatrix._((String)"info.license"));
        licenseItem.setMnemonic(Translatrix._((String)"info.license.key").charAt(0));
        licenseItem.setIcon(Icons.getIcon22("3floppy_unmount.png"));
        this.info.add(licenseItem);
        JMenuItem aboutItem = new JMenuItem(Translatrix._((String)"info.about"));
        aboutItem.setMnemonic(Translatrix._((String)"info.about.key").charAt(0));
        aboutItem.setIcon(Icons.getIcon22("error.png"));
        this.info.add(aboutItem);
        licenseItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JLabel title = new JLabel("<HTML><H2>NazeWiiConf " + NazeWiiConf.VERSION + "</H2></HTML>");
                title.setHorizontalAlignment(0);
                String licenseText = null;
                try {
                    File licenseFile = new File("license.txt");
                    if (Utils.isMac()) {
                        String path = System.getProperty("java.library.path");
                        path = path.substring(0, path.indexOf(":"));
                        licenseFile = new File(path, "license.txt");
                    }
                    FileInputStream licenseIS = new FileInputStream(licenseFile);
                    StringBuilder text = new StringBuilder();
                    String NL = System.getProperty("line.separator");
                    Scanner scanner = new Scanner(licenseIS);
                    while (scanner.hasNextLine()) {
                        text.append(String.valueOf(scanner.nextLine()) + NL);
                    }
                    licenseText = text.toString();
                }
                catch (FileNotFoundException e1) {
                    e1.printStackTrace();
                }
                JTextArea license = new JTextArea(licenseText);
                JScrollPane main = new JScrollPane(license);
                JDialog about = new JDialog(NazeWiiMenu.this.parent);
                about.setIconImage(Icons.getIcon("nazewiiconf.png", 90).getImage());
                about.add((Component)title, "North");
                about.add((Component)main, "Center");
                about.setSize(new Dimension(540, 400));
                about.setLocationRelativeTo(NazeWiiMenu.this.parent);
                about.setVisible(true);
            }
        });
        aboutItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JLabel icon = new JLabel(Icons.getIcon("nazewiiconf.png", 128));
                JLabel title = new JLabel("<HTML><H2>NazeWiiConf " + NazeWiiConf.VERSION + "</H2></HTML>");
                title.setHorizontalAlignment(0);
                JLabel main = new JLabel(Translatrix.getTranslationString((String)"info.about.message"));
                main.setHorizontalAlignment(0);
                JDialog about = new JDialog(NazeWiiMenu.this.parent);
                about.setIconImage(Icons.getIcon("nazewiiconf.png").getImage());
                about.add((Component)title, "North");
                about.add((Component)icon, "West");
                about.add((Component)main, "Center");
                about.setSize(new Dimension(480, 240));
                about.setLocationRelativeTo(NazeWiiMenu.this.parent);
                about.setVisible(true);
            }
        });
    }

    private void initSetupMenu() {
        this.setup = new JMenu(Translatrix._((String)"settings"));
        this.setup.setMnemonic(Translatrix._((String)"settings.key").charAt(0));
        this.setup.addSeparator();
        JMenu langSubMenu = new JMenu(Translatrix._((String)"settings.language"));
        langSubMenu.setMnemonic(Translatrix._((String)"settings.language.key").charAt(0));
        langSubMenu.setIcon(Icons.getIcon22("babelfish.png"));
        this.setup.add(langSubMenu);
        this.createLanguageMenuItem("settings.language.english", "en", "US", Locale.US, "gb.png", langSubMenu);
        this.createLanguageMenuItem("settings.language.german", "de", "DE", Locale.GERMANY, "de.png", langSubMenu);
    }

    private void createLanguageMenuItem(String menuItemString, final String isoLanguage, final String isoCountry, final Locale locale, String icon, JMenu langSubMenu) {
        JMenuItem mi = new JMenuItem(Translatrix._((String)menuItemString));
        mi.setMnemonic(Translatrix._((String)(String.valueOf(menuItemString) + ".key")).charAt(0));
        mi.setIcon(Icons.getIconFlag(icon));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!NazeWiiMenu.this.parent.getLocale().equals(locale == null ? new Locale(isoLanguage, isoCountry) : locale)) {
                    NazeWiiMenu.this.parent.setLocale(isoLanguage, isoCountry);
                    if (NazeWiiMenu.this.parent.restart()) {
                        System.exit(0);
                    }
                }
            }
        });
        langSubMenu.add(mi);
    }

    public static void openURL(String url) {
        try {
            Desktop.getDesktop().browse(new URI(url));
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (URISyntaxException e1) {
            e1.printStackTrace();
        }
    }
}

