/*
 * Decompiled with CFR 0.152.
 */
package de.lazyzero.NazeWiiConf.gui.widget;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.lazyzero.NazeWiiConf.NazeWiiConf;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import lu.tudor.santec.i18n.Translatrix;

public class SettingsWidget
extends JPanel
implements KeyListener {
    private static final long serialVersionUID = 1L;
    private String name;
    private int value;
    private JLabel nameLabel;
    private CellConstraints cc = new CellConstraints();
    private JTextField valueField;
    private NazeWiiConf instance;

    public SettingsWidget(String name, int value, NazeWiiConf instance) {
        this.name = name;
        this.value = value;
        this.instance = instance;
        this.initGUI();
    }

    private void initGUI() {
        this.cc = new CellConstraints();
        String panelColumns = "3dlu, fill:pref:grow, 3dlu, pref, 3dlu";
        String panelRows = "pref";
        FormLayout panelLayout = new FormLayout(panelColumns, panelRows);
        this.setLayout((LayoutManager)panelLayout);
        this.setBorder(new LineBorder(Color.LIGHT_GRAY));
        this.nameLabel = new JLabel();
        this.setName(this.name);
        this.valueField = new JTextField(String.valueOf(this.value), 6);
        this.valueField.addKeyListener(this);
        this.add((Component)this.nameLabel, this.cc.xy(2, 1));
        this.add((Component)this.valueField, this.cc.xy(4, 1));
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
        this.valueField.setText(String.valueOf(value));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.nameLabel.setText(Translatrix._((String)name));
        this.setToolTipText(Translatrix._((String)("tooltip." + name)));
    }

    @Override
    public void keyPressed(KeyEvent event) {
        if (event.getKeyCode() == 10) {
            try {
                this.value = Integer.parseInt(this.valueField.getText());
                this.instance.getMainPanel().getNazeConfiguration().getSettings().put(this.name, this.value);
                this.instance.getMainPanel().getNazeCommunicator().writeSetting(this.name, this.value);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent event) {
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }
}

