/*
 * Decompiled with CFR 0.152.
 */
package de.lazyzero.NazeWiiConf.gui.widget;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.lazyzero.NazeWiiConf.NazeWiiConf;
import de.lazyzero.NazeWiiConf.gui.widget.NazeConfWidget;
import de.lazyzero.NazeWiiConf.utils.NazeConfiguration;
import de.lazyzero.NazeWiiConf.utils.NazeWiiLogger;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.logging.Level;
import javax.swing.JLabel;
import lu.tudor.santec.i18n.Translatrix;

public class StatusWidget
extends NazeConfWidget {
    private static final long serialVersionUID = 1L;
    private NazeWiiLogger logger;
    private JLabel upTimeLabel;
    private JLabel voltageLabel;
    private JLabel cycleTimeLabel;
    private JLabel i2cErrorLabel;
    private JLabel accHWLabel;
    private JLabel upTime;
    private JLabel cycleTime;
    private JLabel voltage;
    private JLabel i2cError;
    private JLabel accHW;
    private JLabel sensors;
    private JLabel sensorsLabel;

    public StatusWidget(String title, NazeWiiConf instance) {
        super(title, instance);
        this.logger = instance.getLogger();
        this.initGUI();
    }

    @Override
    protected void initGUI() {
        this.cc = new CellConstraints();
        String columnSpec = "pref, 3dlu, pref:grow";
        String rowSpec = "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, fill:pref:grow";
        this.panelLayout = new FormLayout(columnSpec, rowSpec);
        this.setLayout((LayoutManager)this.panelLayout);
        this.voltageLabel = new JLabel(String.valueOf(Translatrix._((String)"baseConfPanel.statusWidget.voltageLabel")) + ":");
        this.accHWLabel = new JLabel(String.valueOf(Translatrix._((String)"baseConfPanel.statusWidget.accHWLabel")) + ":");
        this.upTimeLabel = new JLabel(String.valueOf(Translatrix._((String)"baseConfPanel.statusWidget.uptimeLabel")) + ":");
        this.cycleTimeLabel = new JLabel(String.valueOf(Translatrix._((String)"baseConfPanel.statusWidget.cycleTimeLabel")) + ":");
        this.i2cErrorLabel = new JLabel(String.valueOf(Translatrix._((String)"baseConfPanel.statusWidget.i2cErrorLabel")) + ":");
        this.sensorsLabel = new JLabel(String.valueOf(Translatrix._((String)"baseConfPanel.statusWidget.sensorsLabel")) + ":");
        this.voltage = new JLabel();
        this.accHW = new JLabel();
        this.upTime = new JLabel();
        this.cycleTime = new JLabel();
        this.i2cError = new JLabel();
        this.sensors = new JLabel();
        this.add((Component)this.voltageLabel, this.cc.xy(1, 1));
        this.add((Component)this.sensorsLabel, this.cc.xy(1, 3));
        this.add((Component)this.accHWLabel, this.cc.xy(1, 5));
        this.add((Component)this.upTimeLabel, this.cc.xy(1, 7));
        this.add((Component)this.cycleTimeLabel, this.cc.xy(1, 9));
        this.add((Component)this.i2cErrorLabel, this.cc.xy(1, 11));
        this.add((Component)this.voltage, this.cc.xy(3, 1));
        this.add((Component)this.sensors, this.cc.xy(3, 3));
        this.add((Component)this.accHW, this.cc.xy(3, 5));
        this.add((Component)this.upTime, this.cc.xy(3, 7));
        this.add((Component)this.cycleTime, this.cc.xy(3, 9));
        this.add((Component)this.i2cError, this.cc.xy(3, 11));
    }

    public void updateStatus(NazeConfiguration nazeConfiguration) {
        if (nazeConfiguration.getAccHardware() != null) {
            this.accHW.setText(nazeConfiguration.getAccHardware());
        }
        if (nazeConfiguration.getAvailableSensors() != null) {
            String s = "";
            for (String sens : nazeConfiguration.getAvailableSensors()) {
                s = s.concat(String.valueOf(sens) + ", ");
            }
            this.sensors.setText(s);
        }
        if (nazeConfiguration.getCycleTime() != -1) {
            this.cycleTime.setText(String.valueOf(nazeConfiguration.getCycleTime()));
        }
        if (nazeConfiguration.getI2cErrors() != -1) {
            this.i2cError.setText(String.valueOf(nazeConfiguration.getI2cErrors()));
        }
        if (nazeConfiguration.getUptime() != -1) {
            this.upTime.setText(String.valueOf(nazeConfiguration.getUptime()));
        }
        if (nazeConfiguration.getVoltage() != null) {
            this.voltage.setText(nazeConfiguration.getVoltage());
        }
        this.logger.log(Level.INFO, "status values: updated");
    }
}

