/*
 * Decompiled with CFR 0.152.
 */
package de.lazyzero.NazeWiiConf.utils;

import de.lazyzero.NazeWiiConf.NazeWiiConf;
import de.lazyzero.NazeWiiConf.gui.NazeBaseConfPanel;
import de.lazyzero.NazeWiiConf.gui.NazeSettingsPanel;
import de.lazyzero.NazeWiiConf.utils.NazeConfiguration;
import de.lazyzero.NazeWiiConf.utils.NazeListener;
import de.lazyzero.NazeWiiConf.utils.NazePort;
import de.lazyzero.NazeWiiConf.utils.NazeWiiLogger;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Level;
import lu.tudor.santec.i18n.Translatrix;

public class NazeCommunicator
extends Thread
implements NazeListener {
    static String line;
    private NazeListener listener;
    private boolean hasInterrupted = false;
    private NazeConfiguration nazeConfiguration;
    private NazePort serialPort;
    private NazeBaseConfPanel nazeBaseConfPanel;
    private NazeSettingsPanel nazeSettingsPanel;
    private NazeWiiLogger logger;
    private static boolean isReadingSettings;

    public NazeCommunicator(NazeBaseConfPanel nazeBaseConfPanel, NazeSettingsPanel nazeSettingsPanel, NazeConfiguration nazeConfiguration, NazePort serialPort) {
        this.nazeBaseConfPanel = nazeBaseConfPanel;
        this.nazeSettingsPanel = nazeSettingsPanel;
        this.nazeConfiguration = nazeConfiguration;
        this.logger = NazeWiiConf.getInstance().getLogger();
        this.serialPort = serialPort;
    }

    @Override
    public void run() {
        try {
            while ((line = this.serialPort.readLine()) != null && !this.isInterrupted()) {
                if (line.length() <= 1) continue;
                this.listener.dataReceived(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isInterrupted() {
        return this.hasInterrupted;
    }

    public void readMixerList() {
        byte[] command = new byte[]{109, 105, 120, 101, 114, 32, 108, 105, 115, 116, 10};
        try {
            this.serialPort.write(command);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void readEnabledMixer() {
        byte[] command = new byte[]{109, 105, 120, 101, 114, 10};
        try {
            this.serialPort.write(command);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void readMap() {
        byte[] command = new byte[]{109, 97, 112, 10};
        try {
            this.serialPort.write(command);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void readStatus() {
        byte[] command = new byte[]{115, 116, 97, 116, 117, 115, 10};
        try {
            this.serialPort.write(command);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void readVersion() {
        byte[] command = new byte[]{118, 101, 114, 115, 105, 111, 110, 10};
        try {
            this.serialPort.write(command);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void readFeatureList() {
        byte[] command = new byte[]{102, 101, 97, 116, 117, 114, 101, 32, 108, 105, 115, 116, 10};
        try {
            this.serialPort.write(command);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void readEnabledFeatures() {
        byte[] command = new byte[]{102, 101, 97, 116, 117, 114, 101, 10};
        try {
            this.serialPort.write(command);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void readSettings() {
        byte[] command = new byte[]{115, 101, 116, 10};
        try {
            this.serialPort.write(command);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeDefaults() {
        byte[] command = new byte[]{100, 101, 102, 97, 117, 108, 116, 115, 10};
        try {
            this.serialPort.write(command);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeMixer(String name) {
        String mixer = "mixer " + name + '\n';
        byte[] command = mixer.getBytes();
        try {
            this.serialPort.write(command);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.logger.log(Level.INFO, Translatrix._((String)"nazeCommunicator.saveMixer"), true);
    }

    public void writeFeature(String name) {
        String feature = "feature " + name + '\n';
        byte[] command = feature.getBytes();
        try {
            this.serialPort.write(command);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.logger.log(Level.INFO, Translatrix._((String)"nazeCommunicator.saveFeature"), true);
    }

    public void writeMap(String mapping) {
        String map = "map " + mapping + '\n';
        byte[] command = map.getBytes();
        try {
            this.serialPort.write(command);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.logger.log(Level.INFO, Translatrix._((String)"nazeCommunicator.saveMapping"), true);
    }

    public void writeSetting(String name, int value) {
        String setting = "set " + name + "=" + value + '\n';
        byte[] command = setting.getBytes();
        try {
            this.serialPort.write(command);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.logger.log(Level.INFO, Translatrix._((String)"nazeCommunicator.saveSetting"), true);
    }

    public void openCLI() {
        byte[] command = new byte[]{35, 10};
        try {
            this.serialPort.write(command);
            this.logger.log(Level.INFO, "open CLI");
        }
        catch (IOException e) {
            e.printStackTrace();
            this.logger.log(Level.WARNING, "open CLI failed");
            return;
        }
        System.out.println("stop");
    }

    public void closeCLI() {
        byte[] command = new byte[]{101, 120, 105, 116, 10};
        try {
            this.serialPort.write(command);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public NazeListener getListener() {
        return this.listener;
    }

    public void setListener(NazeListener listener) {
        this.listener = listener;
    }

    @Override
    public void dataReceived(String answer) {
        System.out.println(answer);
        if (answer.contains("Entering CLI Mode")) {
            System.out.println("CLI opened!");
        } else if (answer.contains("Saving")) {
            System.out.println("CLI closed!");
        } else if (answer.contains("Available features")) {
            String[] answers;
            Vector<String> features = new Vector<String>();
            features.removeAllElements();
            answer = answer.replaceFirst("Available features:", "").trim();
            String[] stringArray = answers = answer.split(" ");
            int n = answers.length;
            int n2 = 0;
            while (n2 < n) {
                String feature = stringArray[n2];
                features.add(feature);
                ++n2;
            }
            this.nazeConfiguration.setFeatures(features);
            this.nazeBaseConfPanel.updateFeatures();
        } else if (answer.contains("Available mixers")) {
            String[] answers;
            Vector<String> mixers = new Vector<String>();
            mixers.removeAllElements();
            answer = answer.replaceFirst("Available mixers:", "").trim();
            String[] stringArray = answers = answer.split(" ");
            int n = answers.length;
            int n3 = 0;
            while (n3 < n) {
                String mixer = stringArray[n3];
                mixers.add(mixer);
                ++n3;
            }
            this.nazeConfiguration.setMixers(mixers);
            this.nazeBaseConfPanel.updateMixers();
        } else if (answer.contains("Current settings:")) {
            isReadingSettings = true;
        } else if (answer.contains("#")) {
            if (isReadingSettings) {
                isReadingSettings = false;
                this.nazeSettingsPanel.updateSettings();
            }
        } else if (answer.contains("=")) {
            String[] set = answer.split("=");
            this.nazeConfiguration.getSettings().put(set[0].trim(), Integer.parseInt(set[1].trim()));
        } else if (answer.contains("Current assignment")) {
            answer = answer.replaceFirst("Current assignment:", "").trim();
            this.nazeConfiguration.setMap(answer);
            this.nazeBaseConfPanel.updateMap();
        } else if (answer.contains("Enabled features")) {
            String[] answers;
            Vector<String> features = new Vector<String>();
            features.removeAllElements();
            answer = answer.replaceFirst("Enabled features:", "").trim();
            String[] stringArray = answers = answer.split(" ");
            int n = answers.length;
            int n4 = 0;
            while (n4 < n) {
                String feature = stringArray[n4];
                features.add(feature);
                ++n4;
            }
            this.nazeConfiguration.setEnabledFeatures(features);
            this.nazeBaseConfPanel.updateEnabledFeatures();
        } else if (answer.contains("Current mixer")) {
            answer = answer.replaceFirst("Current mixer:", "").trim();
            this.nazeConfiguration.setEnabledMixer(answer);
            this.nazeBaseConfPanel.updateSelectedMixer();
        } else if (answer.contains("System Uptime")) {
            String uptime = answer;
            String voltage = answer;
            uptime = uptime.replaceFirst("System Uptime:", "").trim();
            int i = uptime.indexOf("seconds");
            uptime = uptime.substring(0, i).trim();
            this.nazeConfiguration.setUptime(Integer.parseInt(uptime));
            int j = voltage.indexOf("Voltage");
            voltage = voltage.substring(j + 8).trim();
            this.nazeConfiguration.setVoltage(voltage);
            this.nazeBaseConfPanel.updateStatus();
        } else if (answer.contains("Detected sensors")) {
            String[] sensorsAvailable;
            String sensors = answer;
            String acchw = answer;
            Vector<String> sensorsList = new Vector<String>();
            sensorsList.removeAllElements();
            sensors = sensors.replaceFirst("Detected sensors:", "");
            int i = sensors.indexOf("  ");
            sensors = sensors.substring(0, i).trim();
            String[] stringArray = sensorsAvailable = sensors.split(" ");
            int n = sensorsAvailable.length;
            int n5 = 0;
            while (n5 < n) {
                String sensorAvailable = stringArray[n5];
                sensorsList.add(sensorAvailable);
                ++n5;
            }
            this.nazeConfiguration.setAvailableSensors(sensorsList);
            int j = acchw.indexOf("ACCHW");
            acchw = acchw.substring(j + 6).trim();
            this.nazeConfiguration.setAccHardware(acchw);
            this.nazeBaseConfPanel.updateStatus();
        } else if (answer.contains("Cycle Time")) {
            String cycle = answer;
            String errors = answer;
            cycle = cycle.replaceFirst("Cycle Time:", "").trim();
            int i = cycle.indexOf("I2C");
            cycle = cycle.substring(0, i - 2).trim();
            this.nazeConfiguration.setCycleTime(Integer.parseInt(cycle));
            int j = errors.indexOf("I2C Errors:");
            errors = errors.substring(j + 11).trim();
            this.nazeConfiguration.setI2cErrors(Integer.parseInt(errors));
            this.nazeBaseConfPanel.updateStatus();
        } else if (answer.contains("Resetting to defaults")) {
            System.out.println("Reset Naze to defaults!");
        } else if (answer.contains("version")) {
            answer = answer.replaceFirst("Version:", "").trim();
            this.nazeConfiguration.setVersion(answer);
            this.nazeBaseConfPanel.updateVersion();
        } else if (answer.contains("Rebooting")) {
            this.logger.log(Level.INFO, Translatrix._((String)"nazeCommunicator.reboot"), true);
        } else {
            System.out.println("answer: " + answer);
        }
    }
}

