/*
 * Decompiled with CFR 0.152.
 */
package de.lazyzero.NazeWiiConf.utils;

import java.util.LinkedHashMap;
import java.util.Set;
import java.util.Vector;

public class NazeConfiguration {
    private Vector<String> features = new Vector();
    private Vector<String> enabledFeatures = new Vector();
    private Vector<String> mixers = new Vector();
    private Vector<String> availableSensors = new Vector();
    private String map;
    private String enabledMixer;
    private int uptime;
    private int cycleTime;
    private int i2cErrors;
    private String voltage;
    private String accHardware;
    private String version;
    private LinkedHashMap<String, Integer> settings = new LinkedHashMap();

    public Vector<String> getFeatures() {
        return this.features;
    }

    public void setFeatures(Vector<String> features) {
        this.features = features;
    }

    public Vector<String> getEnabledFeatures() {
        return this.enabledFeatures;
    }

    public void setEnabledFeatures(Vector<String> enabledFeatures) {
        this.enabledFeatures = enabledFeatures;
    }

    public void updateEnabledFeature(String name, boolean isSelected) {
        if (isSelected) {
            this.enabledFeatures.add(name);
        } else {
            this.enabledFeatures.remove(name);
        }
    }

    public Vector<String> getMixers() {
        return this.mixers;
    }

    public void setMixers(Vector<String> mixers) {
        this.mixers = mixers;
    }

    public String getEnabledMixer() {
        return this.enabledMixer;
    }

    public void setEnabledMixer(String enabledMixer) {
        this.enabledMixer = enabledMixer;
    }

    public String getMap() {
        return this.map;
    }

    public void setMap(String map) {
        this.map = map;
    }

    public LinkedHashMap<String, Integer> getSettings() {
        return this.settings;
    }

    public void setSettings(LinkedHashMap<String, Integer> settings) {
        this.settings = settings;
    }

    public int getUptime() {
        return this.uptime;
    }

    public void setUptime(int uptime) {
        this.uptime = uptime;
    }

    public String getVoltage() {
        return this.voltage;
    }

    public void setVoltage(String voltage) {
        this.voltage = voltage;
    }

    public Vector<String> getAvailableSensors() {
        return this.availableSensors;
    }

    public void setAvailableSensors(Vector<String> availableSensors) {
        this.availableSensors = availableSensors;
    }

    public String getAccHardware() {
        return this.accHardware;
    }

    public void setAccHardware(String accHardware) {
        this.accHardware = accHardware;
    }

    public int getCycleTime() {
        return this.cycleTime;
    }

    public void setCycleTime(int cycleTime) {
        this.cycleTime = cycleTime;
    }

    public int getI2cErrors() {
        return this.i2cErrors;
    }

    public void setI2cErrors(int i2cErrors) {
        this.i2cErrors = i2cErrors;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String toString() {
        String string = "Status:\nUptime: " + this.getUptime();
        string = string.concat("\nVoltage: " + this.getVoltage());
        string = string.concat("\nACCHW: " + this.getAccHardware());
        string = string.concat("\nAvailable Sensors: ");
        for (String sensor : this.getAvailableSensors()) {
            string = string.concat(String.valueOf(sensor) + ", ");
        }
        string = string.concat("\nCycle Time: " + this.getCycleTime());
        string = string.concat("\nI2C Errors: " + this.getI2cErrors());
        string = string.concat("\nVersion: " + this.getVersion());
        string = string.concat("\nMap: " + this.getMap());
        string = string.concat("\nMixers: ");
        for (String availableMixer : this.mixers) {
            string = string.concat(String.valueOf(availableMixer) + ", ");
        }
        string = string.concat("\nEnabled Mixer: " + this.enabledMixer);
        string = string.concat("\nFeatures: ");
        for (String availableFeatures : this.features) {
            string = string.concat(String.valueOf(availableFeatures) + ", ");
        }
        string = string.concat("\nEnabled Features: ");
        for (String enabledFeature : this.enabledFeatures) {
            string = string.concat(String.valueOf(enabledFeature) + ", ");
        }
        Set<String> keys = this.settings.keySet();
        string = string.concat("\nSettings:\n");
        for (String key : keys) {
            string = string.concat(String.valueOf(key) + "=" + this.settings.get(key) + ";\n");
        }
        return string;
    }
}

