/*
 * Decompiled with CFR 0.152.
 */
package de.lazyzero.NazeWiiConf.utils;

import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;

public class NazePort {
    private SerialPort serialPort;
    InputStreamReader isr;
    private InputStream in;
    private OutputStream os;
    BufferedReader out;
    private int baud = 9600;
    private String port;
    private boolean portOpened = false;
    private CommPort commPort;

    public NazePort(String port, int baud) {
        this.port = port;
        this.baud = baud;
    }

    public void openPort() throws Exception {
        CommPortIdentifier portIdentifier = CommPortIdentifier.getPortIdentifier(this.port);
        this.commPort = portIdentifier.open("LightController", 2000);
        if (this.commPort instanceof SerialPort) {
            this.serialPort = (SerialPort)this.commPort;
            this.serialPort.setSerialPortParams(this.baud, 8, 1, 0);
            this.in = this.serialPort.getInputStream();
            this.os = this.serialPort.getOutputStream();
            this.isr = new InputStreamReader(this.in);
            this.out = new BufferedReader(this.isr);
            this.setPortOpened(true);
        }
    }

    public void close() throws IOException {
        System.out.println("close Port");
        this.out.close();
        this.in.close();
        this.isr.close();
        this.os.close();
        this.out = null;
        this.in = null;
        this.isr = null;
        this.os = null;
        this.serialPort.close();
        this.commPort.close();
        this.serialPort = null;
        this.commPort = null;
        this.setPortOpened(false);
    }

    public void write(byte[] command) throws IOException {
        this.os.write(command);
    }

    public void write(int command) throws IOException {
        this.os.write(command);
    }

    public String readLine() throws IOException {
        return this.out.readLine();
    }

    public int getBaud() {
        return this.baud;
    }

    public void setBaud(int baud) {
        this.baud = baud;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public boolean isPortOpened() {
        return this.portOpened;
    }

    public void setPortOpened(boolean portOpened) {
        this.portOpened = portOpened;
    }
}

