/*
 * Decompiled with CFR 0.152.
 */
package de.lazyzero.NazeWiiConf.utils;

import de.lazyzero.NazeWiiConf.gui.widget.StateBar;
import de.lazyzero.NazeWiiConf.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class NazeWiiLogger
extends Logger {
    private FileHandler logFile;
    public static File LOG_FILE = new File(System.getProperty("user.dir"), "NazeWiiConf.log");

    public NazeWiiLogger(String name) {
        super(name, null);
        if (Utils.isMac()) {
            LOG_FILE = new File(Utils.getTempFolder(), "NazeWiiConf.log");
        }
        this.initLogger();
    }

    public static NazeWiiLogger getLogger(String name) {
        LogManager manager = LogManager.getLogManager();
        Logger logger = manager.getLogger(name);
        if (logger == null) {
            manager.addLogger(new NazeWiiLogger(name));
        }
        logger = manager.getLogger(name);
        return (NazeWiiLogger)logger;
    }

    private void initLogger() {
        try {
            this.logFile = new FileHandler(LOG_FILE.getAbsolutePath(), false);
            this.logFile.setFormatter(new SimpleFormatter());
            this.logFile.setLevel(Level.INFO);
            this.addHandler(this.logFile);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.setLevel(Level.INFO);
    }

    public void log(Level level, String message, boolean showStateBar) {
        this.log(level, message);
        if (showStateBar) {
            String icon = "not.png";
            if (level.equals(Level.INFO)) {
                icon = "info.png";
            } else if (level.equals(Level.WARNING)) {
                icon = "error.png";
            }
            StateBar.setState(icon, message);
        }
    }

    public static /* bridge */ /* synthetic */ Logger getLogger(String string) {
        return NazeWiiLogger.getLogger(string);
    }
}

