/*
 * Decompiled with CFR 0.152.
 */
package de.lazyzero.NazeWiiConf.utils;

import de.lazyzero.NazeWiiConf.NazeWiiConf;
import de.lazyzero.NazeWiiConf.gui.NazeUploadPanel;
import de.lazyzero.NazeWiiConf.utils.Firmware;
import de.lazyzero.NazeWiiConf.utils.NazeWiiLogger;
import de.lazyzero.NazeWiiConf.utils.ProgressListener;
import de.lazyzero.NazeWiiConf.utils.Utils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Level;
import lu.tudor.santec.i18n.Translatrix;

public class STMLoader {
    private NazeWiiConf instance;
    private ProgressListener progressListner;
    private NazeWiiLogger logger;
    private int count;
    private int errorcount;

    public STMLoader(NazeWiiConf instance, ProgressListener progressListener) {
        this.instance = instance;
        this.progressListner = progressListener;
        this.logger = instance.getLogger();
    }

    public void flashFirmware(Firmware revision) throws IOException {
        Vector<String> cmd = new Vector<String>();
        String stmloader = "";
        if (Utils.isMac()) {
            String path = System.getProperty("java.library.path");
            path = path.substring(0, path.indexOf(":"));
            stmloader = String.valueOf(path) + "/lib/stmloader/mac/stmloader";
        } else if (Utils.isLinux()) {
            stmloader = String.valueOf(System.getProperty("user.dir")) + "/lib/stmloader/linux/stmloader";
        }
        cmd.add(stmloader);
        cmd.add("-p");
        cmd.add(this.instance.getPort());
        cmd.add("-b");
        cmd.add(String.valueOf(this.instance.getBuadrate()));
        cmd.add("-f");
        cmd.add(Utils.getTempFolder() + "/baseflight_r" + revision.getRevision() + ".hex");
        String[] cmdArray = new String[cmd.size()];
        cmd.toArray(cmdArray);
        final Process p = Runtime.getRuntime().exec(cmdArray);
        new Thread(){

            @Override
            public void run() {
                BufferedInputStream bis = new BufferedInputStream(p.getErrorStream());
                try {
                    int line;
                    while ((line = bis.read()) != -1) {
                        System.err.print((char)line);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }.start();
        this.count = 0;
        this.errorcount = 0;
        new Thread(){

            @Override
            public void run() {
                ((NazeUploadPanel)STMLoader.this.progressListner).getUploadButton().setEnabled(false);
                BufferedInputStream bis = new BufferedInputStream(p.getInputStream());
                try {
                    int line;
                    while ((line = bis.read()) != -1) {
                        System.out.print((char)line);
                        if ((char)line == '=') {
                            STMLoader sTMLoader = STMLoader.this;
                            sTMLoader.count = sTMLoader.count + 1;
                            if (STMLoader.this.count != 35) continue;
                            STMLoader.this.progressListner.updateProgressBy(1);
                            STMLoader.this.count = 0;
                            continue;
                        }
                        if ((char)line != 'p') continue;
                        STMLoader sTMLoader = STMLoader.this;
                        sTMLoader.errorcount = sTMLoader.errorcount + 1;
                        if (STMLoader.this.errorcount != 20) continue;
                        STMLoader.this.logger.log(Level.WARNING, Translatrix._((String)"nazeUploadPanel.flashFailedDevice"), true);
                        break;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }.start();
        try {
            p.waitFor();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.out.println("exit: " + p.exitValue());
        if (p.exitValue() == 0) {
            System.out.println("===: " + this.count);
            this.logger.log(Level.INFO, Translatrix._((String)"firmwarePanel.uploadFinished"), true);
            this.progressListner.updateProgress(100);
            ((NazeUploadPanel)this.progressListner).getRefreshButton().setEnabled(true);
            ((NazeUploadPanel)this.progressListner).getUploadButton().setEnabled(true);
        } else {
            this.logger.log(Level.WARNING, Translatrix._((String)"nazeUploadPanel.flashFeiled"), true);
        }
    }
}

