/*
 * Decompiled with CFR 0.152.
 */
package de.lazyzero.NazeWiiConf.utils;

import de.lazyzero.NazeWiiConf.NazeWiiConf;
import de.lazyzero.NazeWiiConf.gui.widget.StateBar;
import de.lazyzero.NazeWiiConf.utils.Firmware;
import de.lazyzero.NazeWiiConf.utils.MD5;
import de.lazyzero.NazeWiiConf.utils.NazeWiiLogger;
import de.lazyzero.NazeWiiConf.utils.Utils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class SVN {
    private String url;
    private String file;
    private String name = "anonymous";
    private String password = "anonymous";
    private long startRevision = 0L;
    private long endRevision = -1L;
    private SVNRepository repository;
    private NazeWiiLogger logger = NazeWiiConf.getInstance().getLogger();
    private TreeMap<Long, Firmware> firmwares;
    private String stateOpenRepositorySuccessfull;
    private String stateNumbersFirmware;
    private String stateFetchRepositorySuccessfull;
    private String stateOpenRepositoryFailed;
    private String stateFetchRevisionFailed;
    private String stateFetchChangelogFailed;
    private String stateFirmwareNotFound;
    private String stateFirmwareDownloadFailed;
    private String stateFirmwareStartDownload;
    private String stateFirmwareFinishedDownload;
    private String stateFirmwareSaveFailed;
    private String stateFirmwareCRCfailed;

    public SVN(String url, String file) throws Exception {
        this.url = url;
        this.file = file;
        this.firmwares = new TreeMap();
        DAVRepositoryFactory.setup();
        long time = System.currentTimeMillis();
        this.openRepository();
        this.logger.log(Level.INFO, "openRepostiory [ms]: " + (System.currentTimeMillis() - time));
        StateBar.setState("info.png", String.valueOf(this.stateOpenRepositorySuccessfull) + " [ms]: " + (System.currentTimeMillis() - time));
        this.fetchRevisions();
        this.logger.log(Level.INFO, "Number of firmwares in svn: " + this.firmwares.size());
        StateBar.setState("info.png", String.valueOf(this.firmwares.size()) + ": " + this.stateNumbersFirmware);
        this.logger.log(Level.INFO, "fetchRevisions [ms]: " + (System.currentTimeMillis() - time));
        StateBar.setState("info.png", String.valueOf(this.stateFetchRepositorySuccessfull) + " [ms]: " + (System.currentTimeMillis() - time));
    }

    private void openRepository() throws Exception {
        this.repository = null;
        try {
            this.repository = SVNRepositoryFactory.create(SVNURL.parseURIEncoded(this.url));
        }
        catch (SVNException svne) {
            this.logger.log(Level.WARNING, "error while creating an SVNRepository for the location '" + this.url + "': " + svne.getMessage(), true);
            throw new Exception("Can't access svn!!!");
        }
        ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager(this.name, this.password);
        this.repository.setAuthenticationManager(authManager);
    }

    private void fetchRevisions() throws Exception {
        try {
            this.endRevision = this.repository.getLatestRevision();
        }
        catch (SVNException svne) {
            this.logger.log(Level.WARNING, "error while fetching the latest repository revision: " + svne.getMessage(), true);
            throw new Exception("Can't fetch latest revision!!!");
        }
        Collection logEntries = null;
        try {
            logEntries = this.repository.log(new String[]{""}, null, this.startRevision, this.endRevision, true, true);
        }
        catch (SVNException svne) {
            this.logger.log(Level.WARNING, "error while collecting log information for '" + this.url + "': " + svne.getMessage(), true);
            throw new Exception("Can't access svn log!!!");
        }
        for (SVNLogEntry logEntry : logEntries) {
            Set<String> changedPathsSet;
            if (logEntry.getChangedPaths().size() <= 0 || !(changedPathsSet = logEntry.getChangedPaths().keySet()).contains(this.file)) continue;
            SVNLogEntryPath entryPath = logEntry.getChangedPaths().get(this.file);
            Firmware firmware = new Firmware(logEntry.getRevision(), logEntry.getAuthor(), logEntry.getDate(), logEntry.getMessage(), entryPath.getPath());
            this.firmwares.put(logEntry.getRevision(), firmware);
        }
    }

    public File getFirmware(long revision) {
        File svnFile;
        ByteArrayOutputStream baos;
        SVNProperties fileProperties;
        block8: {
            SVNNodeKind nodeKind;
            block7: {
                fileProperties = new SVNProperties();
                baos = new ByteArrayOutputStream();
                svnFile = new File(this.file);
                try {
                    nodeKind = this.repository.checkPath(svnFile.getPath(), -1L);
                    if (nodeKind != SVNNodeKind.NONE) break block7;
                    this.logger.log(Level.WARNING, "There is no entry at '" + this.url + "'.");
                    StateBar.setState("error.png", this.stateFirmwareNotFound);
                    return null;
                }
                catch (SVNException svne) {
                    this.logger.log(Level.WARNING, "error while fetching the file contents and properties: " + svne.getMessage());
                    StateBar.setState("error.png", this.stateFirmwareDownloadFailed);
                    return null;
                }
            }
            if (nodeKind != SVNNodeKind.DIR) break block8;
            this.logger.log(Level.WARNING, "The entry at '" + this.url + "' is a directory while a file was expected.");
            StateBar.setState("error.png", this.stateFirmwareNotFound);
            return null;
        }
        StateBar.setState("info.png", this.stateFirmwareStartDownload);
        this.repository.getFile(svnFile.getPath(), revision, fileProperties, baos);
        File saveFile = new File(Utils.getTempFolder() + "/" + "baseflight_r" + revision + ".hex");
        try {
            FileOutputStream fos = new FileOutputStream(saveFile);
            baos.writeTo(fos);
            fos.close();
            this.logger.log(Level.INFO, "File saved: " + saveFile);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            StateBar.setState("error.png", this.stateFirmwareSaveFailed);
        }
        String svnCRC = fileProperties.getStringValue("svn:entry:checksum");
        String fileCRC = MD5.getMD5(saveFile);
        if (fileCRC.equals(svnCRC)) {
            StateBar.setState("info.png", this.stateFirmwareFinishedDownload);
            return saveFile;
        }
        StateBar.setState("error.png", this.stateFirmwareCRCfailed);
        return null;
    }

    public TreeMap<Long, Firmware> getFirmwares() {
        return this.firmwares;
    }
}

