/**
 * 
 */
package de.lazyzero.NazeWiiConf;

import static lu.tudor.santec.i18n.Translatrix._;

import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;

import javax.swing.JFrame;
import javax.swing.JOptionPane;

import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

import de.lazyzero.NazeWiiConf.gui.MainPanel;
import de.lazyzero.NazeWiiConf.gui.NazeBaseConfPanel;
import de.lazyzero.NazeWiiConf.gui.NazeSettingsPanel;
import de.lazyzero.NazeWiiConf.gui.NazeUploadPanel;
import de.lazyzero.NazeWiiConf.gui.widget.NazeWiiMenu;
import de.lazyzero.NazeWiiConf.gui.widget.NazeWiiPanel;
import de.lazyzero.NazeWiiConf.gui.widget.StateBar;
import de.lazyzero.NazeWiiConf.utils.Icons;
import de.lazyzero.NazeWiiConf.utils.NazeWiiLogger;
import de.lazyzero.NazeWiiConf.utils.Utils;

/**
 * @author Christian Moll
 * 
 */
public class NazeWiiConf extends JFrame {

	public static String VERSION = "0.1";
	private boolean isBeta = true;
	private String betaVersion = "6";
	private static final long serialVersionUID = 1L;
	
	public static boolean isNaze = true;
	public static boolean isMWC = false;

	private NazeWiiLogger logger;
	private Locale locale;
	private Properties settings = new Properties();
	public static File SETTINGS_FILE = new File(Utils.getTempFolder(),
			"/NazeWiiConf.properties");

	private boolean isOffline = false;

	private StateBar stateBar;

	private NazeWiiMenu menu;
	private MainPanel mainPanel;
	private NazeWiiPanel firmwareUploadPanel;
	private NazeBaseConfPanel baseConfPanel;
	private NazeSettingsPanel settingsConfPanel;

	

	private static NazeWiiConf instance;

	public NazeWiiConf() {
		instance = this;
		logger = NazeWiiLogger.getLogger(NazeWiiConf.class.getName());
		if (Utils.isMac()) {
			SETTINGS_FILE = new File(System.getProperty("user.home")
					+ "/Library/Preferences/", "NazeWiiConf.properties");
		}
		
		loadSettings();
		loadTranslation();

		Runtime.getRuntime().addShutdownHook(new Thread() {
			public void run() {
				saveSettings();
				try {
					mainPanel.getNazeCommunicator().closeCLI();
				} catch (NullPointerException e) {
					logger.info("CLI already closed.");
				}
			}
		});

		initGUI();

		


	}

	private void initGUI() {
		// create the CellContraints
		CellConstraints cc = new CellConstraints();

		// create the Layout for Panel this
		String panelColumns = "fill:pref:grow";
		String panelRows = "fill:pref:grow, 3dlu, pref";
		FormLayout panelLayout = new FormLayout(panelColumns, panelRows);
		this.setLayout(panelLayout);

		menu = new NazeWiiMenu(this);
		mainPanel = new MainPanel(this);
		firmwareUploadPanel = new NazeUploadPanel(_("firmwarePanel.title"), this);
		baseConfPanel = new NazeBaseConfPanel(_("baseConfPanel.title"), this);
		settingsConfPanel = new NazeSettingsPanel(_("settingsConfPanel.title"), this);
		stateBar = new StateBar();
		
		mainPanel.addTab(baseConfPanel);
		mainPanel.addTab(settingsConfPanel);
		mainPanel.addTab(firmwareUploadPanel);

		this.setJMenuBar(menu.getBar());
		this.setIconImage(Icons.getImage(Icons.app, 16));
		this.setTitle(_("NazeWiiConf") + " " + VERSION + (isBeta?" beta " + betaVersion:"") + " - " + (isOffline?"offline":"online"));

		this.add(mainPanel, cc.xy(1, 1));
		this.add(stateBar, cc.xy(1, 3));

		this.setPreferredSize(new Dimension(840, 450));

		this.pack();
		this.setLocationRelativeTo(null);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		this.setVisible(true);
		
		mainPanel.addTabChangeListener();
	}

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		new NazeWiiConf();

		
	}
	
	
	
	private void loadTranslation() {
		// load the supported locales and the default locale
		Translatrix.loadSupportedLocales("de.lazyzero.NazeWiiConf.gui.resources.supportedLocales");
		Translatrix.setLocale(Translatrix.getDefaultLocale());
		// load resources for core package
		@SuppressWarnings("rawtypes")
		Vector locales = Translatrix.getSupportedLocales();

		if (locales.contains(locale)) {
			Translatrix.setLocale(locale);
		} else {
			locale = Translatrix.getLocale();
		}
		Translatrix
				.addBundle("de.lazyzero.NazeWiiConf.gui.resources.translatrix");

	}


	public void loadSettings() {
		try {
			settings.load(new FileInputStream(SETTINGS_FILE));

			try {
				this.setLocale(
						(String) settings.getProperty("locale.language", "en"),
						(String) settings.getProperty("locale.country", "US"));
			} catch (Exception e) {
			}

		} catch (Exception e) {
			saveSettings();
			logger.log(Level.INFO, e.getMessage());
			e.printStackTrace();
		}
	}

	private void saveSettings() {
		try {
			if (!SETTINGS_FILE.mkdir());
			
			settings.put("locale.language", locale.getLanguage());
			settings.put("locale.country", locale.getCountry());

			settings.store(new FileOutputStream(SETTINGS_FILE), "");
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public static NazeWiiConf getInstance() {
		return instance;
	}

	public NazeWiiLogger getLogger() {
		return logger;
	}

	public boolean isOffline() {
		return isOffline;
	}
	
	public void setOffline(boolean isOffline) {
		this.isOffline = isOffline;
		this.setTitle(_("NazeWiiConf") + " " + VERSION + (isBeta?" beta " + betaVersion:"") + " - " + (isOffline?"offline":"online"));
	}

	public void setLocale(String language, String country) {
		this.locale = new Locale(language, country);
		logger.log(Level.INFO, language + "_" + country);
	}

	public Locale getLocale() {
		return locale;
	}

	public boolean restart() {
		int response = JOptionPane.showConfirmDialog(this, _("restart.dialog"),
				_("restart.title"), JOptionPane.YES_NO_OPTION);
		if (response == 0)
			return true;
		else
			return false;
	}
	
	public MainPanel getMainPanel() {
		return mainPanel;
	}

	public String getPort() {
		return mainPanel.getPort();
	}

	public int getBuadrate() {
		return mainPanel.getBaudrate();
	}

	

}
