package de.lazyzero.NazeWiiConf.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;

import javax.swing.JButton;
import static lu.tudor.santec.i18n.Translatrix._;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

import de.lazyzero.NazeWiiConf.NazeWiiConf;
import de.lazyzero.NazeWiiConf.gui.widget.FeatureConfWidget;
import de.lazyzero.NazeWiiConf.gui.widget.MapConfWidget;
import de.lazyzero.NazeWiiConf.gui.widget.MixerConfWidget;
import de.lazyzero.NazeWiiConf.gui.widget.NazeWiiPanel;
import de.lazyzero.NazeWiiConf.gui.widget.StatusWidget;
import de.lazyzero.NazeWiiConf.gui.widget.VersionWidget;
import de.lazyzero.NazeWiiConf.utils.NazeConfiguration;

public class NazeBaseConfPanel extends NazeWiiPanel implements ActionListener {

	private static final long serialVersionUID = 1L;
	private JButton resetDefaultsButton;
	private JButton cancelSettingsButton;
	private JButton saveSettingsButton;
	
	private MixerConfWidget mixerConfWidget;
	private NazeConfiguration nazeConfiguration;
	private FeatureConfWidget featureConfWidget;
	private VersionWidget versionWidget;
	private StatusWidget statusWidget;
	private MapConfWidget mapConfWidget;
	
	public NazeBaseConfPanel(String title, NazeWiiConf instance) {
		super(title, instance);
		this.initGUI();
	}


	private void initGUI() {
		// create the CellContraints
		CellConstraints cc = new CellConstraints();

		// create the Layout for Panel this
		String panelColumns = "pref:grow(5), 3dlu, pref:grow(5), 3dlu, pref:grow(2), 3dlu, fill:pref:grow(2)";
		String panelRows = "pref:grow(6), 3dlu, pref, 3dlu, pref, 3dlu, fill:pref:grow(6), 3dlu, pref";
		FormLayout panelLayout = new FormLayout(panelColumns, panelRows);
//		int[][] groups = {{1,3},{5,7}};
//		panelLayout.setColumnGroups(groups);
		this.setLayout(panelLayout);
		
		this.mixerConfWidget = new MixerConfWidget(_("baseConfPanel.mixerConfWidget.title"), instance);
		this.featureConfWidget = new FeatureConfWidget(_("baseConfPanel.featureConfWidget.title"), instance);
		this.mapConfWidget = new MapConfWidget(_("baseConfPanel.mapConfWidget.title"), instance);
		this.versionWidget = new VersionWidget(_("baseConfPanel.versionWidget.title"), instance);
		this.statusWidget = new StatusWidget(_("baseConfPanel.statusWidget.title"), instance);
		
		this.resetDefaultsButton = new JButton(_("baseConfPanel.resetDefaultsButton"));
		this.saveSettingsButton = new JButton(_("baseConfPanel.saveSettingsButton"));
		this.cancelSettingsButton = new JButton(_("baseConfPanel.cancelSettingsButton"));
		
		this.cancelSettingsButton.addActionListener(this);
		this.saveSettingsButton.addActionListener(this);
		this.resetDefaultsButton.addActionListener(this);
		
		this.add(this.resetDefaultsButton, cc.xyw(5, 3, 3));
		this.add(this.saveSettingsButton, cc.xy(5, 5));
		this.add(this.cancelSettingsButton, cc.xy(7, 5));
		
		this.add(this.mixerConfWidget, cc.xywh(1, 1, 1, 7));
		this.add(this.featureConfWidget, cc.xywh(3, 1, 1, 7));
		this.add(this.mapConfWidget, cc.xywh(5, 1, 3, 1));
		this.add(this.statusWidget, cc.xywh(5, 7, 3, 1));
		this.add(this.versionWidget, cc.xyw(1, 9, 7));
		
		enableAllButtons(false);
	}


	public void updateMixers() {
		nazeConfiguration = instance.getMainPanel().getNazeConfiguration();
		this.mixerConfWidget.addMixers(nazeConfiguration.getMixers());

		
	}


	public void updateSelectedMixer() {
		nazeConfiguration = instance.getMainPanel().getNazeConfiguration();
		this.mixerConfWidget.setSelectedMixer(nazeConfiguration.getEnabledMixer());
	}


	public void updateEnabledFeatures() {
		nazeConfiguration = instance.getMainPanel().getNazeConfiguration();
		this.featureConfWidget.setEnabledFeatures(nazeConfiguration.getEnabledFeatures());
	}


	public void updateFeatures() {
		nazeConfiguration = instance.getMainPanel().getNazeConfiguration();
		this.featureConfWidget.addFeatures(nazeConfiguration.getFeatures());
	}

	public void updateVersion() {
		nazeConfiguration = instance.getMainPanel().getNazeConfiguration();
		this.versionWidget.updateVersion(nazeConfiguration.getVersion());
	}
	
	public void updateStatus() {
		nazeConfiguration = instance.getMainPanel().getNazeConfiguration();
		this.statusWidget.updateStatus(nazeConfiguration);
	}
	
	public void updateMap() {
		nazeConfiguration = instance.getMainPanel().getNazeConfiguration();
		this.mapConfWidget.updateMap(nazeConfiguration.getMap());
	}


	@Override
	public void actionPerformed(ActionEvent action) {
		if (action.getSource().equals(cancelSettingsButton)) {
			try {
				instance.getMainPanel().closeSerialPort();
			} catch (NullPointerException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			instance.getMainPanel().openPort(true);
		} else if (action.getSource().equals(saveSettingsButton)) {
			instance.getMainPanel().getNazeCommunicator().closeCLI();
			sleep(1000);
//			instance.getMainPanel().getNazeCommunicator().openCLI();
			instance.getMainPanel().openPort(true);
		} else if (action.getSource().equals(resetDefaultsButton)) {
			instance.getMainPanel().getNazeCommunicator().writeDefaults();
			sleep(1000);
			instance.getMainPanel().openPort(true);
		}
	}

	private void sleep(int millis) {
		try {
			Thread.sleep(millis);
		} catch (InterruptedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	public void enableAllButtons(boolean b) {
		cancelSettingsButton.setEnabled(b);
		resetDefaultsButton.setEnabled(b);
		saveSettingsButton.setEnabled(b);
	}


	

	


	


	
}
