package de.lazyzero.NazeWiiConf.gui.widget;

import static lu.tudor.santec.i18n.Translatrix._;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import java.util.logging.Level;

import javax.swing.JCheckBox;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

import de.lazyzero.NazeWiiConf.NazeWiiConf;
import de.lazyzero.NazeWiiConf.utils.NazeWiiLogger;

public class FeatureConfWidget extends NazeConfWidget implements ItemListener {

	private NazeWiiLogger logger;
	private Vector<JCheckBox> checkboxes = new Vector<JCheckBox>();
	private boolean isGUIupdate = false;
	

	public FeatureConfWidget(String title, NazeWiiConf instance) {
		super(title, instance);
		logger = instance.getLogger();
		initGUI();
		
	}

	private static final long serialVersionUID = 1L;

	@Override
	protected void initGUI() {
		cc = new CellConstraints();
		
	}

	public void addFeatures(Vector<String> features) {
		System.err.println("features");
		String columnSpec = "pref:grow, 3dlu, pref:grow";
		String rowSpec = "pref, 3dlu";
		for (int i = 0; i < (features.size()/2)-1; i++) {
			rowSpec = rowSpec.concat(", pref, 3dlu");
		}
		rowSpec = rowSpec.concat(", pref");

		panelLayout = new FormLayout(columnSpec, rowSpec);
		this.setLayout(panelLayout);
		for (JCheckBox c : checkboxes) {
			this.remove(c);
		}
		checkboxes.clear();
		
		int j = 0;
		for (int i = 0; i < features.size(); i++) {
				if (j==2) j=0;
				JCheckBox checkbox = new JCheckBox(features.get(i));
				checkbox.setName(features.get(i));
				checkbox.addItemListener(this);
				checkboxes.add(checkbox);
				this.add(checkbox, cc.xy(2*j+1, 1+i-j));
				j++;
		}
		this.validate();
		logger.log(Level.INFO, _("baseConfPanel.featureConfWidget.featuresLoad"), true);
	}


	@Override
	public void itemStateChanged(ItemEvent item) {
		if (isGUIupdate) return;
		if (item.getStateChange() == ItemEvent.SELECTED) {
			System.err.println(((JCheckBox) item.getSource()).getName() + " selected");
			instance.getMainPanel().getNazeConfiguration().updateEnabledFeature(((JCheckBox) item.getSource()).getName(), ((JCheckBox) item.getSource()).isSelected());
			FeatureConfWidget.this.instance.getMainPanel().getNazeCommunicator().writeFeature(((JCheckBox) item.getSource()).getName());
		} else if (item.getStateChange() == ItemEvent.DESELECTED) {
			System.err.println(((JCheckBox) item.getSource()).getName() + " de-selected");
			instance.getMainPanel().getNazeConfiguration().updateEnabledFeature(((JCheckBox) item.getSource()).getName(), ((JCheckBox) item.getSource()).isSelected());
			FeatureConfWidget.this.instance.getMainPanel().getNazeCommunicator().writeFeature("-"+((JCheckBox) item.getSource()).getName());
		}
		
	}

	public void setEnabledFeatures(Vector<String> enabledFeatures) {
		System.err.println("enabled features: " + enabledFeatures);
		isGUIupdate = true;
		for (JCheckBox checkbox : checkboxes) {
			if (enabledFeatures.contains(checkbox.getName())) {
				checkbox.setSelected(true);
			} else {
				checkbox.setSelected(false);
			}
		}
		isGUIupdate = false;
	}

}
