/**
 * 
 */
package de.lazyzero.NazeWiiConf.gui.widget;

import static lu.tudor.santec.i18n.Translatrix._;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

import de.lazyzero.NazeWiiConf.NazeWiiConf;
import de.lazyzero.NazeWiiConf.utils.NazeWiiLogger;

/**
 * @author moll
 *
 */
public class MapConfWidget extends NazeConfWidget implements ActionListener {
	
	private static final long serialVersionUID = 1L;
	private NazeWiiLogger logger;
	private JTextField mapField;
	private JButton writeButton;
	private JButton jrButton;
	private JButton futabaButton;
	private JButton mpxButton;
	private JButton hitecButton;

	/**
	 * @param title
	 * @param instance
	 */
	public MapConfWidget(String title, NazeWiiConf instance) {
		super(title, instance);
		logger = instance.getLogger();
		initGUI();
	}

	/* (non-Javadoc)
	 * @see de.lazyzero.NazeWiiConf.gui.widget.NazeConfWidget#initGUI()
	 */
	@Override
	protected void initGUI() {
		cc = new CellConstraints();
		String columnSpec = "pref:grow, 3dlu, pref:grow";
		String rowSpec = "pref, 3dlu, pref, 5dlu, pref, 3dlu, pref";
		int[][] groups = {{1,3}};
		
		panelLayout = new FormLayout(columnSpec, rowSpec);
		panelLayout.setColumnGroups(groups);
		this.setLayout(panelLayout);
		
		this.mapField = new JTextField();
		this.writeButton = new JButton(_("baseConfPanel.mapConfWidget.writeButton"));
		
		this.jrButton = new JButton("JR/Spektrum");
		this.futabaButton = new JButton("Futaba");
		this.mpxButton = new JButton("MPX");
		this.hitecButton = new JButton("Hitec");
		
		this.jrButton.addActionListener(this);
		this.futabaButton.addActionListener(this);
		this.mpxButton.addActionListener(this);
		this.hitecButton.addActionListener(this);
		this.writeButton.addActionListener(this);
		
		this.add(mapField, cc.xy(1, 1));
		this.add(writeButton, cc.xy(3, 1));
		this.add(new JSeparator(), cc.xyw(1, 3, 3));
		this.add(jrButton, cc.xy(1, 5));
		this.add(futabaButton, cc.xy(3, 5));
		this.add(mpxButton, cc.xy(1, 7));
		this.add(hitecButton, cc.xy(3, 7));
	}

	public void updateMap(String map) {
		this.mapField.setText(map);
	}

	@Override
	public void actionPerformed(ActionEvent action) {
		if (action.getSource().equals(writeButton)) {
			instance.getMainPanel().getNazeConfiguration().setMap(this.mapField.getText());
			instance.getMainPanel().getNazeCommunicator().writeMap(this.mapField.getText());
		} else if (action.getSource().equals(futabaButton)) {
			this.mapField.setText("AETR1234");
		} else if (action.getSource().equals(jrButton)) {
			this.mapField.setText("TAER1234");
		} else if (action.getSource().equals(hitecButton)) {
			this.mapField.setText("AETR1234");
		} else if (action.getSource().equals(mpxButton)) {
			this.mapField.setText("AERT1234");
		}
	}

}
