package de.lazyzero.NazeWiiConf.gui.widget;

import static lu.tudor.santec.i18n.Translatrix._;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import java.util.logging.Level;

import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

import de.lazyzero.NazeWiiConf.NazeWiiConf;
import de.lazyzero.NazeWiiConf.utils.NazeConfiguration;
import de.lazyzero.NazeWiiConf.utils.NazeWiiLogger;

public class MixerConfWidget extends NazeConfWidget implements ItemListener {

	private NazeWiiLogger logger;
	private ButtonGroup buttonGroup;
	private boolean isGUIupdate = false;
	private HashMap<String, JRadioButton> buttons = new HashMap<String, JRadioButton>();
	

	public MixerConfWidget(String title, NazeWiiConf instance) {
		super(title, instance);
		logger = instance.getLogger();
		initGUI();
		
	}

	private static final long serialVersionUID = 1L;

	@Override
	protected void initGUI() {
		cc = new CellConstraints();
		
	}

	public void addMixers(Vector<String> mixers) {
		System.err.println("mixer");
		String columnSpec = "pref:grow, 3dlu, pref:grow";
		String rowSpec = "pref, 3dlu";
		for (int i = 0; i < (mixers.size()/2)-1; i++) {
			rowSpec = rowSpec.concat(", pref, 3dlu");
		}
		rowSpec = rowSpec.concat(", pref");
		

		
		panelLayout = new FormLayout(columnSpec, rowSpec);
		
		this.setLayout(panelLayout);
		buttonGroup = new ButtonGroup();
		
		for (JRadioButton b : buttons.values()) {
			this.remove(b);
		}
		
		buttons.clear();
		
		int j = 0;
		for (int i = 0; i < mixers.size(); i++) {
				if (j==2) j=0;
				JRadioButton radio = new JRadioButton(mixers.get(i));
				radio.setName(mixers.get(i));
				radio.addItemListener(this);
				buttons.put(mixers.get(i), radio);
				buttonGroup.add(radio);
				this.add(radio, cc.xy(2*j+1, 1+i-j));
				j++;
		}
		
		logger.log(Level.INFO, _("baseConfPanel.mixerConfWidget.mixersLoad"), true);
		this.validate();
	}


	@Override
	public void itemStateChanged(ItemEvent item) {
		if (isGUIupdate) return;
		if (item.getStateChange() == ItemEvent.SELECTED) {
			System.err.println(((JRadioButton)item.getSource()).getName() + " selected");
			this.instance.getMainPanel().getNazeConfiguration().setEnabledMixer(((JRadioButton)item.getSource()).getName());
			MixerConfWidget.this.instance.getMainPanel().getNazeCommunicator().writeMixer(((JRadioButton)item.getSource()).getName());
		} else if (item.getStateChange() == ItemEvent.DESELECTED) {
			System.err.println(((JRadioButton)item.getSource()).getName() + " de-selected");
		}
	}

	public void setSelectedMixer(String enabledMixer) {
		System.err.println("mixer: " + enabledMixer);
		isGUIupdate  = true;
		buttons.get(enabledMixer).setSelected(true);
		isGUIupdate = false;
	}

}
