package de.lazyzero.NazeWiiConf.gui.widget;

import static lu.tudor.santec.i18n.Translatrix._;

import java.awt.BorderLayout;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Scanner;

import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import lu.tudor.santec.i18n.Translatrix;
import de.lazyzero.NazeWiiConf.NazeWiiConf;
import de.lazyzero.NazeWiiConf.utils.Icons;
import de.lazyzero.NazeWiiConf.utils.NazeWiiLogger;
import de.lazyzero.NazeWiiConf.utils.SendLogFile;
import de.lazyzero.NazeWiiConf.utils.Utils;

public class NazeWiiMenu extends JMenuBar {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private JMenu setup;
	private JMenu info;
	private JMenu help;

	private JMenuBar bar;
	private NazeWiiConf parent;
	

	public NazeWiiMenu(NazeWiiConf parent) {
		this.parent = parent;
		
		initSetupMenu();
		initHelpMenu();
		initInfoMenu();
				
		bar = new JMenuBar();
		bar.add(setup);
		bar.add(help);
		bar.add(info);
	}

	public JMenuBar getBar() {
		return bar;
	}

	private void initHelpMenu() {
		help = new JMenu(_("help"));
		help.setMnemonic(_("help.key").charAt(0));
		
		JMenuItem mailItem = new JMenuItem(_("help.mail"));
		mailItem.setMnemonic(_("help.mail.key").charAt(0));
		mailItem.setIcon(Icons.getIcon22(Icons.MAIL));
		help.add(mailItem);
		
		mailItem.addActionListener(
				new ActionListener(){
					public void actionPerformed(ActionEvent e) {
						SendLogFile slf = new SendLogFile();
						slf.sendMail(NazeWiiConf.VERSION, NazeWiiLogger.LOG_FILE);
					}
				}
		);
		
		help.addSeparator();
		
		JMenuItem helpItem = new JMenuItem(_("help"));
		helpItem.setMnemonic(_("help.help.key").charAt(0));
		helpItem.setIcon(Icons.getIcon22(Icons.LZ));
		help.add(helpItem);
		
		helpItem.addActionListener(
				new ActionListener(){
					public void actionPerformed(ActionEvent e) {
						openURL("http://www.lazyzero.de/en/modellbau/nazewiiconf");
					}
				}
		);
		
		
	}
	
	private void initInfoMenu() {
		info = new JMenu(_("info"));
		info.setMnemonic(_("info.key").charAt(0));
		
		JMenuItem licenseItem = new JMenuItem(_("info.license"));
		licenseItem.setMnemonic(_("info.license.key").charAt(0));
		licenseItem.setIcon(Icons.getIcon22(Icons.LICENSE));
		info.add(licenseItem);
		
		JMenuItem aboutItem = new JMenuItem(_("info.about"));
		aboutItem.setMnemonic(_("info.about.key").charAt(0));
		aboutItem.setIcon(Icons.getIcon22(Icons.ABOUT));
		info.add(aboutItem);
		
		licenseItem.addActionListener(
				new ActionListener(){
					public void actionPerformed(ActionEvent e)
					{
						JLabel title = new JLabel("<HTML><H2>NazeWiiConf " + NazeWiiConf.VERSION +"</H2></HTML>");
						title.setHorizontalAlignment(JLabel.CENTER);
						String licenseText = null;
						
						try {
							File licenseFile = new File("license.txt");
							if (Utils.isMac()) {
								String path = System.getProperty("java.library.path");
					        	path = path.substring(0, path.indexOf(":"));
								licenseFile = new File(path,"license.txt");
							}
							FileInputStream licenseIS = new FileInputStream(licenseFile);
							
							StringBuilder text = new StringBuilder();
						    String NL = System.getProperty("line.separator");
						    Scanner scanner = new Scanner(licenseIS);

						    while (scanner.hasNextLine()) {
						    	text.append(scanner.nextLine() + NL);
						    }
						    licenseText = text.toString();
						    
						} catch (FileNotFoundException e1) {
							e1.printStackTrace();
						} 
						
						JTextArea license = new JTextArea(licenseText);
						JScrollPane main = new JScrollPane(license);
						
						JDialog about = new JDialog(parent);
						about.setIconImage(Icons.getIcon(Icons.app, 90).getImage());
						about.add(title, BorderLayout.NORTH);
						about.add(main, BorderLayout.CENTER);
						about.setSize(new Dimension(540,400));
						about.setLocationRelativeTo(parent);
						about.setVisible(true);
					}
				}
		);
		
		aboutItem.addActionListener(
				new ActionListener(){
					public void actionPerformed(ActionEvent e)
					{
						JLabel icon = new JLabel(Icons.getIcon(Icons.app, 128));
						JLabel title = new JLabel("<HTML><H2>NazeWiiConf " + NazeWiiConf.VERSION +"</H2></HTML>");
						title.setHorizontalAlignment(JLabel.CENTER);
						JLabel main = new JLabel(Translatrix.getTranslationString("info.about.message"));
						main.setHorizontalAlignment(JLabel.CENTER);
						
						JDialog about = new JDialog(parent);
						about.setIconImage(Icons.getIcon(Icons.app).getImage());
						about.add(title, BorderLayout.NORTH);
						about.add(icon, BorderLayout.WEST);
						about.add(main, BorderLayout.CENTER);
						about.setSize(new Dimension(480,240));
						about.setLocationRelativeTo(parent);
						about.setVisible(true);
					}
				}
			);
	}

	private void initSetupMenu() {
		setup = new JMenu(_("settings"));
		setup.setMnemonic(_("settings.key").charAt(0));
		
		setup.addSeparator();
		
		JMenu langSubMenu = new JMenu(_("settings.language"));
		langSubMenu.setMnemonic(_("settings.language.key").charAt(0));
		langSubMenu.setIcon(Icons.getIcon22(Icons.LANGUAGE));
		setup.add(langSubMenu);
		
		createLanguageMenuItem("settings.language.english", "en", "US", Locale.US, Icons.ENGLISH, langSubMenu);
//		createLanguageMenuItem("settings.language.french", "fr", "FR", Locale.FRANCE, Icons.FRENCH, langSubMenu);
		createLanguageMenuItem("settings.language.german", "de", "DE", Locale.GERMANY, Icons.GERMAN, langSubMenu);
//		createLanguageMenuItem("settings.language.italian", "it", "IT", Locale.ITALY, Icons.ITALIAN, langSubMenu);
//		createLanguageMenuItem("settings.language.dutch", "nl", "NL", null, Icons.DUTCH, langSubMenu);
//		createLanguageMenuItem("settings.language.chinese", "zh", "CN", null, Icons.CHINESE, langSubMenu);
//		createLanguageMenuItem("settings.language.turkish", "tr", "TR", null, Icons.TURKISH, langSubMenu);
//		createLanguageMenuItem("settings.language.faroese", "fo", "FO", null, Icons.FAROESE, langSubMenu);
//		createLanguageMenuItem("settings.language.danish", "da", "DK", null, Icons.DANISH, langSubMenu);
//		createLanguageMenuItem("settings.language.swedish", "se", "SE", null, Icons.SWEDISH, langSubMenu);
//		createLanguageMenuItem("settings.language.brazilian", "pt", "BR", null, Icons.BRAZILIAN, langSubMenu);
//		createLanguageMenuItem("settings.language.polish", "pl", "PL", null, Icons.POLISH, langSubMenu);
//		createLanguageMenuItem("settings.language.spanish", "es", "ES", null, Icons.SPANISH, langSubMenu);
//		createLanguageMenuItem("settings.language.russian", "ru", "RU", null, Icons.RUSSIAN, langSubMenu);
//		createLanguageMenuItem("settings.language.portugese", "pt", "PT", null, Icons.PORTUGESE, langSubMenu);
//		createLanguageMenuItem("settings.language.korean", "kr", "KR", null, Icons.KOREAN, langSubMenu);
//		createLanguageMenuItem("settings.language.slovakian", "sk", "SK", null, Icons.SLOVAKIAN, langSubMenu);
//		createLanguageMenuItem("settings.language.czech", "cz", "CZ", null, Icons.CZECH, langSubMenu);
//		createLanguageMenuItem("settings.language.hebrew", "iw", "IL", null, Icons.HEBREW, langSubMenu);
//		createLanguageMenuItem("settings.language.croatian", "hr", "HR", null, Icons.CROATIAN, langSubMenu);
//		createLanguageMenuItem("settings.language.greek", "gr", "GR", null, Icons.GREEK, langSubMenu);
//		createLanguageMenuItem("settings.language.romanian", "ro", "RO", null, Icons.ROMANIAN, langSubMenu);
//		createLanguageMenuItem("settings.language.norwegian", "no", "NO", null, Icons.NORWEGIAN, langSubMenu);
//		createLanguageMenuItem("settings.language.slovenian", "sl", "SI", null, Icons.SLOVENIAN, langSubMenu);
//		createLanguageMenuItem("settings.language.japanese", "ja", "JP", null, Icons.JAPANESE, langSubMenu);
//		createLanguageMenuItem("settings.language.hungarian", "hu", "HU", null, Icons.HUNGARIAN, langSubMenu);
//		createLanguageMenuItem("settings.language.bosnian", "bs", "BA", null, Icons.BOSNIAN, langSubMenu);
//		createLanguageMenuItem("settings.language.serbian", "cs", "SR", null, Icons.SERBIAN, langSubMenu);
	}
	
	private void createLanguageMenuItem(String menuItemString, final String isoLanguage, final String isoCountry, final Locale locale, String icon, JMenu langSubMenu) {
		JMenuItem mi = new JMenuItem(_(menuItemString));
		mi.setMnemonic(_(menuItemString + ".key").charAt(0));
		mi.setIcon(Icons.getIconFlag(icon));
		
		mi.addActionListener(
				new ActionListener(){
					public void actionPerformed(ActionEvent e)
					{
						if (!parent.getLocale().equals(locale==null?new Locale(isoLanguage, isoCountry):locale)){
							parent.setLocale(isoLanguage, isoCountry);
							if (parent.restart()){
								System.exit(0);
							}
						}
					}
				}
			);
		
		langSubMenu.add(mi);
	}

	public static void openURL(String url) {
		try {
			Desktop.getDesktop().browse(new URI(url));
		} catch (IOException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		} catch (URISyntaxException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}
	}
}
