package de.lazyzero.NazeWiiConf.gui.widget;

import static lu.tudor.santec.i18n.Translatrix._;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Vector;
import java.util.logging.Level;

import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

import de.lazyzero.NazeWiiConf.NazeWiiConf;
import de.lazyzero.NazeWiiConf.utils.NazeWiiLogger;

public class SettingsConfWidget extends NazeConfWidget {
	
	private static final long serialVersionUID = 1L;
	
	private NazeWiiLogger logger;
	private boolean isGUIupdate = false;

	private HashMap<String, SettingsWidget> settingsElements = new HashMap<String, SettingsWidget>();
	
	public SettingsConfWidget(String title, NazeWiiConf instance) {
		super(title, instance);
		logger = instance.getLogger();
		initGUI();
	}

	@Override
	protected void initGUI() {
		cc = new CellConstraints();

	}

	public void updateSettings(LinkedHashMap<String, Integer> settings) {
		System.err.println("settings");
		String columnSpec = "pref:grow, 3dlu, pref:grow, 3dlu, pref:grow, 3dlu, pref:grow";
		String rowSpec = "pref, 3dlu";
		for (int i = 0; i < (settings.size()/4)-1; i++) {
			rowSpec = rowSpec.concat(", pref, 3dlu");
		}
		rowSpec = rowSpec.concat(", pref");
		
		panelLayout = new FormLayout(columnSpec, rowSpec);
		
		this.setLayout(panelLayout);
		
		
		for (SettingsWidget se : settingsElements.values()) {
			this.remove(se);
		}
		settingsElements.clear();
	
		Iterator<String> it = settings.keySet().iterator();
		int column = 1;
		int row = 1;
		while (it.hasNext()) {
			if (column > 7) {
				column=1;
				row++;row++;
			}
			String key = (String) it.next();
			SettingsWidget s = new SettingsWidget(key, settings.get(key), instance);
			settingsElements.put(key, s);
			this.add(s, cc.xy(column, row));
			column++;column++;
		}
		
		
		logger.log(Level.INFO, _("settingsConfPanel.settingsConfWidget.settingsLoad"), true);
		this.validate();
	}

}
