/**
 * 
 */
package de.lazyzero.NazeWiiConf.gui.widget;

import static lu.tudor.santec.i18n.Translatrix._;

import java.awt.Color;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.LineBorder;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

import de.lazyzero.NazeWiiConf.utils.Icons;

/**
 * @author moll
 * 
 */
public class StateBar extends JPanel {

	private static final long serialVersionUID = 1L;
	private CellConstraints cc;
	private JLabel stateLabel;
	private JLabel stateIcon;
	private static StateBar instance;

	public StateBar() {
		instance = this;
		// create the CellContraints
		cc = new CellConstraints();

		// create the Layout for Panel this
		String panelColumns = "pref, 3dlu, fill:pref";
		String panelRows = "pref";
		FormLayout panelLayout = new FormLayout(panelColumns, panelRows);
		this.setLayout(panelLayout);
		this.setBackground(getBackground().brighter());
		this.setBorder(new LineBorder(Color.black));

		stateLabel = new JLabel(_("started"));
		System.out.println(_("started"));
		stateIcon = new JLabel(Icons.getIcon16(Icons.INFO));

		this.add(stateIcon, cc.xy(1, 1, "r,b"));
		this.add(stateLabel, cc.xy(3, 1, "r,b"));
	}

	public static void setState(String icon, String state) {
		instance.stateLabel.setText(state);
		instance.stateIcon.setIcon(Icons.getIcon16(icon));

		instance.repaint();

	}
}
