package de.lazyzero.NazeWiiConf.gui.widget;

import static lu.tudor.santec.i18n.Translatrix._;

import java.util.logging.Level;

import javax.swing.JLabel;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

import de.lazyzero.NazeWiiConf.NazeWiiConf;
import de.lazyzero.NazeWiiConf.utils.NazeConfiguration;
import de.lazyzero.NazeWiiConf.utils.NazeWiiLogger;

public class StatusWidget extends NazeConfWidget {
	private static final long serialVersionUID = 1L;
	private NazeWiiLogger logger;
	private JLabel upTimeLabel;
	private JLabel voltageLabel;
	private JLabel cycleTimeLabel;
	private JLabel i2cErrorLabel;
	private JLabel accHWLabel;
	private JLabel upTime;
	private JLabel cycleTime;
	private JLabel voltage;
	private JLabel i2cError;
	private JLabel accHW;
	private JLabel sensors;
	private JLabel sensorsLabel;

	public StatusWidget(String title, NazeWiiConf instance) {
		super(title, instance);
		logger = instance.getLogger();
		initGUI();
	}

	@Override
	protected void initGUI() {
		cc = new CellConstraints();
		String columnSpec = "pref, 3dlu, pref:grow";
		String rowSpec = "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, fill:pref:grow";
		panelLayout = new FormLayout(columnSpec, rowSpec);
		this.setLayout(panelLayout);
		
		this.voltageLabel = new JLabel(_("baseConfPanel.statusWidget.voltageLabel")+":");
		this.accHWLabel = new JLabel(_("baseConfPanel.statusWidget.accHWLabel")+":");
		this.upTimeLabel = new JLabel(_("baseConfPanel.statusWidget.uptimeLabel")+":");
		this.cycleTimeLabel = new JLabel(_("baseConfPanel.statusWidget.cycleTimeLabel")+":");
		this.i2cErrorLabel = new JLabel(_("baseConfPanel.statusWidget.i2cErrorLabel")+":");
		this.sensorsLabel = new JLabel(_("baseConfPanel.statusWidget.sensorsLabel")+":");
		
		this.voltage = new JLabel();
		this.accHW = new JLabel();
		this.upTime = new JLabel();
		this.cycleTime = new JLabel();
		this.i2cError = new JLabel();
		this.sensors = new JLabel();
		
		this.add(voltageLabel, cc.xy(1, 1));
		this.add(sensorsLabel, cc.xy(1, 3));
		this.add(accHWLabel, cc.xy(1, 5));
		this.add(upTimeLabel, cc.xy(1, 7));
		this.add(cycleTimeLabel, cc.xy(1, 9));
		this.add(i2cErrorLabel, cc.xy(1, 11));
		
		this.add(voltage, cc.xy(3, 1));
		this.add(sensors, cc.xy(3, 3));
		this.add(accHW, cc.xy(3, 5));
		this.add(upTime, cc.xy(3, 7));
		this.add(cycleTime, cc.xy(3, 9));
		this.add(i2cError, cc.xy(3, 11));
		
	}

	public void updateStatus(NazeConfiguration nazeConfiguration) {
		if (nazeConfiguration.getAccHardware() != null) {
			accHW.setText(nazeConfiguration.getAccHardware());
		}
		if (nazeConfiguration.getAvailableSensors() != null) {
			String s = "";
			for (String sens : nazeConfiguration.getAvailableSensors()) {
				s = s.concat(sens + ", ");
			}
			sensors.setText(s);
		}
		if (nazeConfiguration.getCycleTime() != -1) {
			cycleTime.setText(nazeConfiguration.getCycleTime() +"");
		}
		if (nazeConfiguration.getI2cErrors() != -1) {
			i2cError.setText(nazeConfiguration.getI2cErrors() +"");
		}
		if (nazeConfiguration.getUptime() != -1) {
			upTime.setText(nazeConfiguration.getUptime() +"");
		}
		if (nazeConfiguration.getVoltage() != null) {
			voltage.setText(nazeConfiguration.getVoltage());
		}
		logger.log(Level.INFO, "status values: updated");
	}

}
