package de.lazyzero.NazeWiiConf.gui.widget;

import java.util.logging.Level;

import javax.swing.JLabel;
import javax.swing.border.Border;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

import de.lazyzero.NazeWiiConf.NazeWiiConf;
import de.lazyzero.NazeWiiConf.utils.NazeWiiLogger;

public class VersionWidget extends NazeConfWidget {

	private static final long serialVersionUID = 1L;
	private NazeWiiLogger logger;
	private JLabel versionLabel;

	public VersionWidget(String title, NazeWiiConf instance) {
		super(title, instance);
		logger = instance.getLogger();
		initGUI();
	}

	@Override
	protected void initGUI() {
		versionLabel = new JLabel();
		cc = new CellConstraints();
		String columnSpec = "3dlu, pref:grow";
		String rowSpec = "pref:grow";
		panelLayout = new FormLayout(columnSpec, rowSpec);
		this.setLayout(panelLayout);
		this.add(versionLabel, cc.xy(2, 1));
	}

	public void updateVersion(String version) {
		System.out.println("version: " + version.length());
		this.versionLabel.setText(version);
		logger.log(Level.INFO, "version updated in GUI: " + version);
	}

}
