/**
 * 
 */
package de.lazyzero.NazeWiiConf.utils;

import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * @author Christian Moll
 *
 */
public class Firmware {

	private long revision;
	private String author;
	private Date date;
	private String message;
	private String path;
	
	private SimpleDateFormat sdf = new SimpleDateFormat("dd MMMM yyyy");

	public Firmware(long revision, String author, Date date, String message,
			String path) {
		this.revision = revision;
		this.author = author;
		this.date = date;
		this.message = parseMessage(message);
		this.path = path;
	}

	private String parseMessage(String message) {
		String messageOut = "<html>";
		String[] messages = message.split("\n");
//		messageOut = messageOut.concat("<ul>");
		for (String string : messages) {
			messageOut = messageOut.concat("<li>"+string+"</li>");
		}
//		messageOut = messageOut.concat("</ul>");
		return messageOut;
	}

	public long getRevision() {
		return revision;
	}

	public String getAuthor() {
		return author;
	}

	public Date getDate() {
		return date;
	}

	public String getMessage() {
		return message;
	}

	public String getPath() {
		return path;
	}
	
	public String toString() {
		return "r" + getRevision() + ": " + getAuthor() + ": " + sdf.format(getDate());
		
	}

}
