package de.lazyzero.NazeWiiConf.utils;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.Vector;

public class NazeConfiguration {

	private Vector<String> features = new Vector<String>();
	private Vector<String> enabledFeatures = new Vector<String>();
	private Vector<String> mixers = new Vector<String>();
	private Vector<String> availableSensors = new Vector<String>();
	
	private String map;
	private String enabledMixer;
	private int uptime;
	private int cycleTime;
	private int i2cErrors;
	private String voltage;
	private String accHardware;
	private String version;
	private LinkedHashMap<String, Integer> settings = new LinkedHashMap<String, Integer>();
	
	public Vector<String> getFeatures() {
		return features;
	}
	public void setFeatures(Vector<String> features) {
		this.features = features;
	}
	
	public Vector<String> getEnabledFeatures() {
		return enabledFeatures;
	}
	public void setEnabledFeatures(Vector<String> enabledFeatures) {
		this.enabledFeatures = enabledFeatures;
	}
	public void updateEnabledFeature(String name, boolean isSelected) {
		if (isSelected) {
			enabledFeatures.add(name);
		} else {
			enabledFeatures.remove(name);	
		}
	}
	
	public Vector<String> getMixers() {
		return mixers;
	}
	public void setMixers(Vector<String> mixers) {
		this.mixers = mixers;
	}
	public String getEnabledMixer() {
		return enabledMixer;
	}
	public void setEnabledMixer(String enabledMixer) {
		this.enabledMixer = enabledMixer;
	}
	public String getMap() {
		return map;
	}
	public void setMap(String map) {
		this.map = map;
	}
	public LinkedHashMap<String, Integer> getSettings() {
		return settings;
	}
	public void setSettings(LinkedHashMap<String, Integer> settings) {
		this.settings = settings;
	}
	
	public int getUptime() {
		return uptime;
	}
	public void setUptime(int uptime) {
		this.uptime = uptime;
	}
	public String getVoltage() {
		return voltage;
	}
	public void setVoltage(String voltage) {
		this.voltage = voltage;
	}
	public Vector<String> getAvailableSensors() {
		return availableSensors;
	}
	public void setAvailableSensors(Vector<String> availableSensors) {
		this.availableSensors = availableSensors;
	}
	public String getAccHardware() {
		return accHardware;
	}
	public void setAccHardware(String accHardware) {
		this.accHardware = accHardware;
	}
	public int getCycleTime() {
		return cycleTime;
	}
	public void setCycleTime(int cycleTime) {
		this.cycleTime = cycleTime;
	}
	public int getI2cErrors() {
		return i2cErrors;
	}
	public void setI2cErrors(int i2cErrors) {
		this.i2cErrors = i2cErrors;
	}
	public String getVersion() {
		return version;
	}
	public void setVersion(String version) {
		this.version = version;
	}
	public String toString() {
		String string = "Status:\nUptime: " + getUptime();
		string = string.concat("\nVoltage: " + getVoltage());
		string = string.concat("\nACCHW: " + getAccHardware());
		string = string.concat("\nAvailable Sensors: ");
		for (String sensor : getAvailableSensors()) {
			string = string.concat(sensor + ", ");
		}
		string = string.concat("\nCycle Time: " + getCycleTime());
		string = string.concat("\nI2C Errors: " + getI2cErrors());
		
		string = string.concat("\nVersion: " + getVersion());
				
		string = string.concat("\nMap: " + getMap());
		
		string = string.concat("\nMixers: ");
		for (String availableMixer : mixers) {
			string = string.concat(availableMixer + ", ");
		}
		
		string = string.concat("\nEnabled Mixer: " + enabledMixer);
		
		string = string.concat("\nFeatures: ");
		for (String availableFeatures : features) {
			string = string.concat(availableFeatures + ", ");
		}
		
		string = string.concat("\nEnabled Features: ");
		for (String enabledFeature : enabledFeatures) {
			string = string.concat(enabledFeature + ", ");
		}
		
		Set<String> keys = settings.keySet();
		string = string.concat("\nSettings:\n");
		for (String key : keys) {
			string = string.concat(key + "=" + settings.get(key) + ";\n");
		}	
		
		return string;
	}

	
}
