/**
 * 
 */
package de.lazyzero.NazeWiiConf.utils;

import java.io.File;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

import de.lazyzero.NazeWiiConf.gui.widget.StateBar;

/**
 * @author moll
 *
 */
public class NazeWiiLogger extends Logger{
	private FileHandler logFile;
	public static File LOG_FILE	= new File(System.getProperty("user.dir"), "NazeWiiConf.log");
	
	
	public NazeWiiLogger(String name) {
		super(name, null);
		//check if the OS is Mac OS X
		if (Utils.isMac()) {
			LOG_FILE = new File(Utils.getTempFolder(),"NazeWiiConf.log");
		}
		initLogger();
	}
	
	public static NazeWiiLogger getLogger(String name){
		LogManager manager = LogManager.getLogManager();
		Object logger = manager.getLogger(name);
		if (logger == null) manager.addLogger(new NazeWiiLogger(name));
		logger = manager.getLogger(name);
		return (NazeWiiLogger)logger;
	}
	
	private void initLogger() {
		try {
			logFile = new FileHandler(LOG_FILE.getAbsolutePath(), false);
			logFile.setFormatter(new SimpleFormatter());
			logFile.setLevel(Level.INFO);
			this.addHandler(logFile);
			
		} catch (SecurityException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		this.setLevel(Level.INFO);
	}
	
	public void log(Level level, String message, boolean showStateBar) {
		log(level, message);
		if (showStateBar) {
			String icon = Icons.STOP;
			if (level.equals(Level.INFO)) {
				icon  = Icons.INFO;
			} else if (level.equals(Level.WARNING)) {
				icon = Icons.ERROR;
			}
			StateBar.setState(icon, message);
		}
	}
	

	
}
