package de.lazyzero.NazeWiiConf.utils;

import java.awt.Desktop;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;

public class SendLogFile {
	private Desktop desktop;
	

	public SendLogFile() {
		if (Desktop.isDesktopSupported()) {
	        desktop = Desktop.getDesktop();
		}
		
		
	}
	
	public boolean sendMail(String version, File file)  {
		String filecontent = "";
		
		try {
			FileReader fr = new FileReader(file);
			int c;
			while((c = fr.read())!=-1) {
				filecontent=filecontent.concat(((char)c)+"");
			}
		} catch (FileNotFoundException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		
		try {
			
			String defaultContent = "Please add here some additional information to help me solving the problem.\n\n";
			URI mailtoURI = new URI("mailto", "christian@chrmoll.de?SUBJECT=NazeWiiConf: "+version+"&BODY=" + defaultContent + filecontent, null);
			desktop.mail(mailtoURI);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return false;
		} catch (URISyntaxException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return false;
		}
		
		return true;
	}
	
	public boolean sendMail(String version, LinkedHashMap<String, String> data) {
		Set<String> keys = data.keySet();
		String content = "";
		for (Iterator<String> iterator = keys.iterator(); iterator.hasNext();) {
			String key = iterator.next();
			content=content.concat(key + "==" + data.get(key)+"\n");
		}
		
		try {
			URI mailtoURI = new URI("mailto", "christian@chrmoll.de?SUBJECT=NazeWiiConf: "+version+"&BODY=" +  content, null);
			desktop.mail(mailtoURI);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return false;
		} catch (URISyntaxException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return false;
		}
		
		return true;
	}
	
	
}
