package de.lazyzero.NazeWiiConf.utils;

import java.io.File;

public class Utils {
	public static boolean isWindows() {
		return (System.getProperty("os.name").toLowerCase().contains("windows")?true:false);
	}

	public static boolean isMac() {
		return (System.getProperty("os.name").toLowerCase().contains("mac")?true:false);
	}
	
	public static boolean isLinux() {
		return (System.getProperty("os.name").toLowerCase().contains("linux")?true:false);
	}
	
	public static File getTempFolder() {
		String tmpdir;
		if (Utils.isWindows()) {
            tmpdir = System.getProperty("user.dir")+"\\tmp\\";
        } else if (Utils.isMac()) {
			tmpdir = System.getProperty("user.home")+"/Library/Preferences/NazeWiiConf/";
		} else {
        	tmpdir = System.getProperty("user.dir")+"/tmp/";
        }
		System.out.println(tmpdir);
		//Great tmp folder if it is not existing. 
		if ((new File(tmpdir)).mkdir()) System.out.println("tmpdir created");
		return new File(tmpdir);
	}

	

}
